/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.dictionaryindex.builder;

import ja.JaTestCase;
import ja.centre.util.io.intio.MockIntWriter;
import ja.lingo.engine.dictionaryindex.Token;

import java.io.IOException;

public class TokenBuilderTest extends JaTestCase {
    public void testDelegaedMethodCalls() throws IOException {
        final int TOKEN0_START  = 10;
        final int TOKEN0_LENGTH = 20;

        final int TOKEN1_START  = 30;
        final int TOKEN1_LENGTH = 40;

        MockIntWriter mockIntWriter = new MockIntWriter();

        TokenBuilder bodyBuilder = new TokenBuilder( mockIntWriter );

        assertEquals( 0, bodyBuilder.getTokensWrittenCount() );

        bodyBuilder.put( new Token( TOKEN0_START, TOKEN0_LENGTH) );
        assertEquals( 1, bodyBuilder.getTokensWrittenCount() );

        bodyBuilder.put( new Token( TOKEN1_START, TOKEN1_LENGTH) );
        assertEquals( 2, bodyBuilder.getTokensWrittenCount() );

        bodyBuilder.close();

        try {
            bodyBuilder.close();
        } catch ( IllegalStateException e ) {
            // do nothing
        }

        // verify
        assertEquals( TOKEN0_START, mockIntWriter.getInt( 0 ) );
        assertEquals( TOKEN0_LENGTH, mockIntWriter.getInt( 1 ) );

        assertEquals( TOKEN1_START, mockIntWriter.getInt( 2 ) );
        assertEquals( TOKEN1_LENGTH, mockIntWriter.getInt( 3 ) );

        assertTrue( mockIntWriter.isClosed() );
    }
}
