/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.sort.external;

import ja.centre.util.sort.ComparableComparator;
import junit.framework.TestCase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MergingMultipartReaderTest extends TestCase {
    public void test() throws IOException {
        List<String> sortedValues1 = Arrays.asList( new String[] { "a", "b", "c", "d", "e", "f", "g" } );
        List<String> sortedValues2 = Arrays.asList( new String[] { "b", "g", "z" } );
        List<String> sortedValues3 = Arrays.asList( new String[] { "1", "f", "t", "y" } );

        List<String> expected = new ArrayList<String>();
        expected.addAll( sortedValues1 ) ;
        expected.addAll( sortedValues2 ) ;
        expected.addAll( sortedValues3 ) ;
        Collections.sort( expected, new ComparableComparator<String>() );

        List<IReader<String>> readers = new ArrayList<IReader<String>>();
        readers.add( new CollectionReader<String>( sortedValues1 ) );
        readers.add( new CollectionReader<String>( sortedValues2 ) );
        readers.add( new CollectionReader<String>( sortedValues3 ) );

        // test
        IReader<String> reader = new MergingMultipartReader<String>( readers, new ComparableComparator<String>() );

        // check
        List<String> actual = new ArrayList<String>();
        while ( reader.hasNext() ) {
            actual.add( reader.next() );
        }
        reader.close();

        assertEquals( expected, actual );
    }
}
