/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.sort;

import junit.framework.TestCase;

import java.util.Arrays;
import java.util.List;

public class QuickSorterTest extends TestCase {
    public void testSort() {
        List<String> source   = Arrays.asList( new String[] { "s", "ddd", "zz", "Fwee", "12", "rerw", "ASD" } );
        List<String> expected = Arrays.asList( new String[] { "12", "ASD", "Fwee", "ddd", "rerw", "s", "zz" } );

        ListSortSubject<String> subject = new ListSortSubject<String>( source );

        ISorter<String> sorter = new QuickSorter<String>();
        sorter.sort( subject, new ComparableComparator<String>() );

        // check
        assertEquals( expected, subject.asList() );
    }
}
