/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.propertytool;

import ja.JaTestCase;

public class PropertyToolTest extends JaTestCase {
    public void testSimplePropertyExtraction() throws PropertyToolException {
        final String NAME = "name value";
        MockBean mockBean = new MockBean( NAME );

        Object component = PropertyTool.getValue( mockBean, "name" );

        assertSame( NAME, component );
    }

    public void testNestedPropertyExtraction() throws PropertyToolException {
        final String NESTED_NAME = "nested name value";
        MockBean mockBean = new MockBean( new MockBean( NESTED_NAME ) );

        Object component = PropertyTool.getValue( mockBean, "nestedMockBean.name" );

        assertSame( NESTED_NAME, component );
    }

    public void testNonExistentNestedPropertyExtraction() throws PropertyToolException {
        final String NESTED_NAME = "nested name value";
        MockBean mockBean = new MockBean( new  MockBean( NESTED_NAME ) );

        try {
            PropertyTool.getValue( mockBean, "nestedMockBean.nonExistent.name" );
            failExpected( PropertyToolException.class );
        } catch ( PropertyToolException e ) {
            // do nothing
        }
    }

    // TODO 2 more test cases

}
