/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.propertytool;

class MockBean {
    private String name;
    private MockBean nestedMockBean;
    private String privateName;

    public MockBean() {
    }
    public MockBean( String name ) {
        this.name = name;
    }
    public MockBean( String name, MockBean nestedMockBean ) {
        this.name = name;
        this.nestedMockBean = nestedMockBean;
    }
    public MockBean( MockBean nestedMockBean ) {
        this.nestedMockBean = nestedMockBean;
    }

    /**
     * @param dooDad - just a doo-dad parameter
     */
    public MockBean( String privateName, boolean dooDad ) {
        this.privateName = privateName;
    }

    public String getName() {
        return name;
    }
    public void setName( String name ) {
        this.name = name;
    }

    public MockBean getNestedMockBean() {
        return nestedMockBean;
    }
    public void setNestedMockBean( MockBean nestedMockBean ) {
        this.nestedMockBean = nestedMockBean;
    }

    String getPrivateName() {
        return privateName;
    }
    void setPrivateName( String privateName ) {
        this.privateName = privateName;
    }
}
