/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.io.intio;

import ja.centre.util.assertions.States;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

public class MockIntWriter implements IIntWriter {
    private boolean closed;
    private List<Integer> values = new ArrayList<Integer>();

    public void writeInt( int value ) throws IOException {
        values.add( value );
    }

    public int getIntsWrittenCount() {
        return values.size();
    }

    public void close() throws IOException {
        States.assertFalse( closed, "Expected to be not closed" );
        closed = true;
    }

    public boolean isClosed() {
        return closed;
    }

    public int getInt( int index ) {
        return values.get( index );
    }
}