/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.io;

import ja.centre.util.arrays.ArrayUtil;
import ja.centre.util.io.Files;
import junit.framework.TestCase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class FilesTest extends TestCase {
    public void testRemoveUnacceptableSymbols() throws Exception {
        assertEquals( "a---b---c---d", Files.removeUnacceptableSymbols( "a/\\:b*?\"c<>|d" ) );
    }
    public void testCopy() throws Exception {
        byte[] source = new byte[] { 1, 2, 3, 4, 5 };

        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Files.copy( new ByteArrayInputStream( source ), os );

        assertEquals( ArrayUtil.asList( source ), ArrayUtil.asList( os.toByteArray() ) );
    }
}