/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.gui.actionbinder.examples;

import ja.centre.gui.actionbinder.ActionBinder;
import ja.centre.gui.actionbinder.config.NListener;

import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * Example of simple binding
 */
public class Example1 {
    @NListener ( type = ActionListener.class, mappings = "actionPerformed > ok" )
    private JButton okButton = new JButton( "OK" );

    public Example1() {
        ActionBinder.bind( this );

/*
        // compare to old fashion way:
        okButton.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent e ) {
                ok( e );
            }
        } );
*/
    }

    public void ok( ActionEvent e ) {
        System.out.println( "ok" );
    }

    public static void main( String[] args ) {
        JFrame frame = new JFrame( "Example1" );
        frame.setContentPane( new Example1().okButton );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        frame.pack();
        frame.setLocationRelativeTo( null );
        frame.setVisible( true );
    }
}
