/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.gui.actionbinder.config;

import ja.JaTestCase;
import ja.centre.gui.actionbinder.ActionBinderException;

import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;

public class ConfigTest extends JaTestCase {
    public void testComplex() throws ConfigException {
        Config config = Config.fromAnnotations( ComplexAnnotatedGui.class );

        assertEquals( 3, config.getListeners().size() );

        {
            Listener listener = config.getListeners().get( 0 );
            assertEquals( "dialog", listener.getComponent() );
            assertEquals( WindowListener.class.getName(), listener.getType() );

            assertEquals( 1, listener.getEvents().size() );
            assertEquals( "windowClosing", listener.getEvents().get( 0 ).getMethod() );
            assertEquals( "hideDialog",    listener.getEvents().get( 0 ).getAction().getMethod() );
        }

        {
            Listener listener = config.getListeners().get( 1 );
            assertEquals( "dialog", listener.getComponent() );
            assertEquals( MouseListener.class.getName(), listener.getType() );

            assertEquals( 2, listener.getEvents().size() );

            Event mousePressedEvent = listener.getEvents().get( 0 );
            assertEquals( "mousePressed",       mousePressedEvent.getMethod() );
            assertEquals( "askConfirmation",    mousePressedEvent.getAction().getMethod() );
            assertEquals( "doSomethingCritical",mousePressedEvent.getAction().getAction().getMethod() );

            Event mouseReleasedEvent = listener.getEvents().get( 1 );
            assertEquals( "mouseReleased",      mouseReleasedEvent.getMethod() );
            assertEquals( "askConfirmation",    mouseReleasedEvent.getAction().getMethod() );
            assertEquals( "askForSure",         mouseReleasedEvent.getAction().getAction().getMethod() );
            assertEquals( "doSomethingCritical",mouseReleasedEvent.getAction().getAction().getAction().getMethod() );
        }

        {
            Listener listener = config.getListeners().get( 2 );
            assertEquals( "dialog.jMenuBar", listener.getComponent() );
            assertEquals( ComponentListener.class.getName(), listener.getType() );

            Event componentShown = listener.getEvents().get( 0 );
            assertEquals( "componentShown",     componentShown.getMethod() );
            assertEquals( "refreshSomething",   componentShown.getAction().getMethod() );
        }
    }

    public void testListenerOutOfComponent() throws ConfigException {
        Config config = Config.fromAnnotations( ListenerOutOfComponentGui.class );

        assertEquals( 1, config.getListeners().size() );

        {
            Listener listener = config.getListeners().get( 0 );
            assertEquals( "dialog", listener.getComponent() );
            assertEquals( WindowListener.class.getName(), listener.getType() );

            assertEquals( 1, listener.getEvents().size() );
            assertEquals( "windowClosing", listener.getEvents().get( 0 ).getMethod() );
            assertEquals( "hideDialog",    listener.getEvents().get( 0 ).getAction().getMethod() );
        }
    }

    public void testWrongEventOnly() throws ConfigException {
        try {
            Config.fromAnnotations( WrongEventOnlyGui.class );
            failExpected( ActionBinderException.class );
        } catch ( ConfigException e ) {
            // do nothing
        }
    }

    public void testWrongEmptyMappings() throws ConfigException {
        try {
            Config.fromAnnotations( WrongEmptyMappingsGui.class );
            failExpected( ActionBinderException.class );
        } catch ( ConfigException e ) {
            // do nothing
        }
    }

    public void testWrongSpacesPreserved() throws ConfigException {
        Config config = Config.fromAnnotations( WrongSpacesGui.class );

        assertEquals( "ask Confirmation", config.getListeners().get( 0 ).getEvents().get( 0 ).getAction().getMethod() );
    }

    public void testWrongComponentAndListenerTogether() throws ConfigException {
        try {
            Config.fromAnnotations( WrongBothComponentAndListenerGui.class );
            failExpected( ActionBinderException.class );
        } catch ( ConfigException e ) {
            // do nothing
        }
    }
}
