/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.setup.panels;

import ja.lingo.setup.WestBoxLayuouter;
import ja.lingo.setup.GuiHelper;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import java.awt.*;
import static java.awt.BorderLayout.CENTER;
import static java.awt.BorderLayout.EAST;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class Panel2Destination extends JPanel {
    private JCheckBox desktopCheckBox;
    private JCheckBox startMenuCheckBox;
    private JTextField destinationField;
    private JFileChooser chooser;

    private String defaultDirName;

    public Panel2Destination( String defaultDestination, String defaultDirName, boolean canCreatelShortcuts ) {
        this.defaultDirName = defaultDirName;

        chooser = new JFileChooser();
        chooser.setDialogTitle( GuiHelper.TITLE );
        chooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );

        JButton browseButton = new JButton( " ... " );

        // try make it smaller
        try {
            browseButton.setBorder( ((CompoundBorder) browseButton.getBorder()).getOutsideBorder() );
        } catch ( ClassCastException e ) {
            // NOTE: do nothing
        }
        browseButton.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent e ) {
                browse();
            }
        } );

        destinationField = new JTextField( "test1", 36 );
        destinationField.setText( calculateFullDestination( defaultDestination ) );

        desktopCheckBox = new JCheckBox( "Create Desktop shortcut" );
        startMenuCheckBox = new JCheckBox( "Create Start Menu shortcut" );

        if ( canCreatelShortcuts ) {
            desktopCheckBox.setSelected( true );
            startMenuCheckBox.setSelected( true );
        } else {
            desktopCheckBox.setVisible( false );
            startMenuCheckBox.setVisible( false );
        }

        JPanel destinationPanel = new JPanel( new BorderLayout( GuiHelper.GAP, GuiHelper.GAP ) );
        destinationPanel.add( destinationField, CENTER );
        destinationPanel.add( browseButton, EAST );

        JPanel panel = new WestBoxLayuouter<JPanel>( new JPanel() )
                .add( new JLabel( "Destination Folder:" ) )
                .add( destinationPanel )
                .addSeparator()
                .add( desktopCheckBox )
                .add( startMenuCheckBox )
                .getContainer();

        setLayout( new BorderLayout() );
        add( GuiHelper.wrap( panel, BorderLayout.NORTH ), BorderLayout.WEST );
    }

    private String calculateFullDestination( String defaultDestination ) {
        return defaultDestination + File.separator + defaultDirName;
    }

    private void browse() {
        if ( chooser.showOpenDialog( this ) == JFileChooser.APPROVE_OPTION ) {
            destinationField.setText(
                    calculateFullDestination( chooser.getSelectedFile().getAbsolutePath() ) );
        }
    }

    public String getDestination() {
        return destinationField.getText();
    }

    public boolean isDesktopSelected() {
        return desktopCheckBox.isSelected();
    }

    public boolean isStartMenuSelected() {
        return startMenuCheckBox.isSelected();
    }
}