/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import info.clearthought.layout.TableLayoutConstants;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected static final int C = 0;
    protected static final int R = 1;
    protected static boolean checkForComponentOrientationSupport = true;
    protected static Method methodGetComponentOrientation;
    protected double[][] crSpec = new double[2][];
    protected int[][] crSize = new int[2][];
    protected int[][] crOffset = new int[2][];
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;
    protected int hGap;
    protected int vGap;

    public TableLayout() {
        this.init(defaultSize[0], defaultSize[1]);
    }

    public TableLayout(double[][] dArray) {
        if (dArray == null || dArray.length != 2) {
            throw new IllegalArgumentException("Parameter size should be an array, a[2], where a[0] is the is an array of column widths and a[1] is an array or row heights.");
        }
        this.init(dArray[0], dArray[1]);
    }

    public TableLayout(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    protected void init(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new IllegalArgumentException("Parameter col cannot be null");
        }
        if (dArray2 == null) {
            throw new IllegalArgumentException("Parameter row cannot be null");
        }
        this.crSpec[0] = new double[dArray.length];
        this.crSpec[1] = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.crSpec[0], 0, this.crSpec[0].length);
        System.arraycopy(dArray2, 0, this.crSpec[1], 0, this.crSpec[1].length);
        int n = 0;
        while (n < this.crSpec[0].length) {
            if (this.crSpec[0][n] < 0.0 && this.crSpec[0][n] != -1.0 && this.crSpec[0][n] != -2.0 && this.crSpec[0][n] != -3.0) {
                this.crSpec[0][n] = 0.0;
            }
            ++n;
        }
        n = 0;
        while (n < this.crSpec[1].length) {
            if (this.crSpec[1][n] < 0.0 && this.crSpec[1][n] != -1.0 && this.crSpec[1][n] != -2.0 && this.crSpec[1][n] != -3.0) {
                this.crSpec[1][n] = 0.0;
            }
            ++n;
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.cr1[0], entry.cr1[1], entry.cr2[0], entry.cr2[1], entry.alignment[0], entry.alignment[1]);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints tableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (tableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.set(new Entry(component, tableLayoutConstraints));
        }
    }

    public void setColumn(double[] dArray) {
        this.setCr(0, dArray);
    }

    public void setRow(double[] dArray) {
        this.setCr(1, dArray);
    }

    protected void setCr(int n, double[] dArray) {
        this.crSpec[n] = new double[dArray.length];
        System.arraycopy(dArray, 0, this.crSpec[n], 0, this.crSpec[n].length);
        int n2 = 0;
        while (n2 < this.crSpec[n].length) {
            if (this.crSpec[n][n2] < 0.0 && this.crSpec[n][n2] != -1.0 && this.crSpec[n][n2] != -2.0 && this.crSpec[n][n2] != -3.0) {
                this.crSpec[n][n2] = 0.0;
            }
            ++n2;
        }
        this.dirty = true;
    }

    public void setColumn(int n, double d) {
        this.setCr(0, n, d);
    }

    public void setRow(int n, double d) {
        this.setCr(1, n, d);
    }

    protected void setCr(int n, int n2, double d) {
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        this.crSpec[n][n2] = d;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] dArray = new double[this.crSpec[0].length];
        System.arraycopy(this.crSpec[0], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] getRow() {
        double[] dArray = new double[this.crSpec[1].length];
        System.arraycopy(this.crSpec[1], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double getColumn(int n) {
        return this.crSpec[0][n];
    }

    public double getRow(int n) {
        return this.crSpec[1][n];
    }

    public int getNumColumn() {
        return this.crSpec[0].length;
    }

    public int getNumRow() {
        return this.crSpec[1].length;
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }

    public void setHGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter hGap must be non-negative.");
        }
        this.hGap = n;
    }

    public void setVGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter vGap must be non-negative.");
        }
        this.vGap = n;
    }

    public void insertColumn(int n, double d) {
        this.insertCr(0, n, d);
    }

    public void insertRow(int n, double d) {
        this.insertCr(1, n, d);
    }

    public void insertCr(int n, int n2, double d) {
        if (n2 < 0 || n2 > this.crSpec[n].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + this.crSpec[n].length + "].");
        }
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        double[] dArray = new double[this.crSpec[n].length + 1];
        System.arraycopy(this.crSpec[n], 0, dArray, 0, n2);
        System.arraycopy(this.crSpec[n], n2, dArray, n2 + 1, this.crSpec[n].length - n2);
        dArray[n2] = d;
        this.crSpec[n] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n] >= n2) {
                int n3 = n;
                entry.cr1[n3] = entry.cr1[n3] + 1;
            }
            if (entry.cr2[n] < n2) continue;
            int n4 = n;
            entry.cr2[n4] = entry.cr2[n4] + 1;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n) {
        this.deleteCr(0, n);
    }

    public void deleteRow(int n) {
        this.deleteCr(1, n);
    }

    protected void deleteCr(int n, int n2) {
        if (n2 < 0 || n2 >= this.crSpec[n].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + (this.crSpec[n].length - 1) + "].");
        }
        double[] dArray = new double[this.crSpec[n].length - 1];
        System.arraycopy(this.crSpec[n], 0, dArray, 0, n2);
        System.arraycopy(this.crSpec[n], n2 + 1, dArray, n2, this.crSpec[n].length - n2 - 1);
        this.crSpec[n] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n] > n2) {
                int n3 = n;
                entry.cr1[n3] = entry.cr1[n3] - 1;
            }
            if (entry.cr2[n] <= n2) continue;
            int n4 = n;
            entry.cr2[n4] = entry.cr2[n4] - 1;
        }
        this.dirty = true;
    }

    public String toString() {
        int n;
        String string = "TableLayout {{";
        if (this.crSpec[0].length > 0) {
            n = 0;
            while (n < this.crSpec[0].length - 1) {
                string = String.valueOf(string) + this.crSpec[0][n] + ", ";
                ++n;
            }
            string = String.valueOf(string) + this.crSpec[0][this.crSpec[0].length - 1] + "}, {";
        } else {
            string = String.valueOf(string) + "}, {";
        }
        if (this.crSpec[1].length > 0) {
            n = 0;
            while (n < this.crSpec[1].length - 1) {
                string = String.valueOf(string) + this.crSpec[1][n] + ", ";
                ++n;
            }
            string = String.valueOf(string) + this.crSpec[1][this.crSpec[1].length - 1] + "}}";
        } else {
            string = String.valueOf(string) + "}}";
        }
        return string;
    }

    public List getInvalidEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            ListIterator listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Entry entry = (Entry)listIterator.next();
                if (entry.cr1[1] >= 0 && entry.cr1[0] >= 0 && entry.cr2[1] < this.crSpec[1].length && entry.cr2[0] < this.crSpec[0].length) continue;
                linkedList.add(entry.copy());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    public List getOverlappingEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            int n = this.list.size();
            if (n == 0) {
                return linkedList;
            }
            Entry[] entryArray = this.list.toArray(new Entry[n]);
            int n2 = 1;
            while (n2 < n) {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    if (entryArray[n3].cr1[0] >= entryArray[n2].cr1[0] && entryArray[n3].cr1[0] <= entryArray[n2].cr2[0] && entryArray[n3].cr1[1] >= entryArray[n2].cr1[1] && entryArray[n3].cr1[1] <= entryArray[n2].cr2[1] || entryArray[n3].cr2[0] >= entryArray[n2].cr1[0] && entryArray[n3].cr2[0] <= entryArray[n2].cr2[0] && entryArray[n3].cr2[1] >= entryArray[n2].cr1[1] && entryArray[n3].cr2[1] <= entryArray[n2].cr2[1]) {
                        linkedList.add(entryArray[n3].copy());
                    }
                    --n3;
                }
                ++n2;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    protected void calculateSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        if (this.crSpec[0].length > 0) {
            n -= this.hGap * (this.crSpec[0].length - 1);
        }
        if (this.crSpec[1].length > 0) {
            n2 -= this.vGap * (this.crSpec[1].length - 1);
        }
        this.crSize[0] = new int[this.crSpec[0].length];
        this.crSize[1] = new int[this.crSpec[1].length];
        n = this.assignAbsoluteSize(0, n);
        n2 = this.assignAbsoluteSize(1, n2);
        n = this.assignPrefMinSize(0, n, -3.0);
        n = this.assignPrefMinSize(0, n, -2.0);
        n2 = this.assignPrefMinSize(1, n2, -3.0);
        n2 = this.assignPrefMinSize(1, n2, -2.0);
        n = this.assignRelativeSize(0, n);
        n2 = this.assignRelativeSize(1, n2);
        this.assignFillSize(0, n);
        this.assignFillSize(1, n2);
        this.calculateOffset(0, insets);
        this.calculateOffset(1, insets);
        this.dirty = false;
        this.oldWidth = dimension.width;
        this.oldHeight = dimension.height;
    }

    protected int assignAbsoluteSize(int n, int n2) {
        int n3 = this.crSpec[n].length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.crSpec[n][n4] >= 1.0 || this.crSpec[n][n4] == 0.0) {
                this.crSize[n][n4] = (int)(this.crSpec[n][n4] + 0.5);
                n2 -= this.crSize[n][n4];
            }
            ++n4;
        }
        return n2;
    }

    protected int assignRelativeSize(int n, int n2) {
        int n3 = n2 < 0 ? 0 : n2;
        int n4 = this.crSpec[n].length;
        int n5 = 0;
        while (n5 < n4) {
            if (this.crSpec[n][n5] > 0.0 && this.crSpec[n][n5] < 1.0) {
                this.crSize[n][n5] = (int)(this.crSpec[n][n5] * (double)n3 + 0.5);
                n2 -= this.crSize[n][n5];
            }
            ++n5;
        }
        return n2;
    }

    protected void assignFillSize(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        int n4 = this.crSpec[n].length;
        int n5 = 0;
        while (n5 < n4) {
            if (this.crSpec[n][n5] == -1.0) {
                ++n3;
            }
            ++n5;
        }
        n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            if (this.crSpec[n][n6] == -1.0) {
                this.crSize[n][n6] = n2 / n3;
                n5 -= this.crSize[n][n6];
            }
            ++n6;
        }
        n6 = n4 - 1;
        while (n6 >= 0 && n5 > 0) {
            if (this.crSpec[n][n6] == -1.0) {
                int[] nArray = this.crSize[n];
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                --n5;
            }
            --n6;
        }
    }

    protected void calculateOffset(int n, Insets insets) {
        int n2 = this.crSpec[n].length;
        this.crOffset[n] = new int[n2 + 1];
        this.crOffset[n][0] = n == 0 ? insets.left : insets.top;
        int n3 = 0;
        while (n3 < n2) {
            this.crOffset[n][n3 + 1] = this.crOffset[n][n3] + this.crSize[n][n3];
            ++n3;
        }
    }

    protected int assignPrefMinSize(int n, int n2, double d) {
        int n3 = this.crSpec[n].length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.crSpec[n][n4] == d) {
                int n5 = 0;
                ListIterator listIterator = this.list.listIterator(0);
                block1: while (listIterator.hasNext()) {
                    int n6;
                    Dimension dimension;
                    Entry entry = (Entry)listIterator.next();
                    if (entry.cr1[n] < 0 || entry.cr2[n] >= n3 || entry.cr1[n] > n4 || entry.cr2[n] < n4) continue;
                    Dimension dimension2 = dimension = d == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n7 = dimension == null ? 0 : (n == 0 ? dimension.width : dimension.height);
                    int n8 = 0;
                    if (d == -2.0) {
                        n6 = entry.cr1[n];
                        while (n6 <= entry.cr2[n]) {
                            if (this.crSpec[n][n6] >= 0.0 || this.crSpec[n][n6] == -3.0) {
                                n7 -= this.crSize[n][n6];
                            } else if (this.crSpec[n][n6] == -2.0) {
                                ++n8;
                            } else if (this.crSpec[n][n6] == -1.0) continue block1;
                            ++n6;
                        }
                    } else {
                        n6 = entry.cr1[n];
                        while (n6 <= entry.cr2[n]) {
                            if (this.crSpec[n][n6] >= 0.0) {
                                n7 -= this.crSize[n][n6];
                            } else if (this.crSpec[n][n6] == -2.0 || this.crSpec[n][n6] == -3.0) {
                                ++n8;
                            } else if (this.crSpec[n][n6] == -1.0) continue block1;
                            ++n6;
                        }
                    }
                    n7 = (int)Math.ceil((double)n7 / (double)n8);
                    if (n5 >= n7) continue;
                    n5 = n7;
                }
                this.crSize[n][n4] = n5;
                n2 -= n5;
            }
            ++n4;
        }
        return n2;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            try {
                ListIterator listIterator = this.list.listIterator(0);
                Entry entry = null;
                while (listIterator.hasNext()) {
                    entry = (Entry)listIterator.next();
                    if (entry.component == componentArray[n]) break;
                    entry = null;
                }
                if (entry == null) {
                    componentArray[n].setBounds(0, 0, 0, 0);
                } else {
                    Object object;
                    int n2 = 0;
                    int n3 = 0;
                    if (entry.alignment[0] != 2 || entry.alignment[1] != 2) {
                        object = componentArray[n].getPreferredSize();
                        n2 = ((Dimension)object).width;
                        n3 = ((Dimension)object).height;
                    }
                    object = this.calculateSizeAndOffset(entry, n2, true);
                    Object object2 = object[0];
                    Object object3 = object[1];
                    object = this.calculateSizeAndOffset(entry, n3, false);
                    Object object4 = object[0];
                    Object object5 = object[1];
                    ComponentOrientation componentOrientation = this.getComponentOrientation(container);
                    if (!componentOrientation.isLeftToRight()) {
                        object2 = dimension.width - object2 - object3;
                    }
                    componentArray[n].setBounds((int)object2, (int)object4, (int)object3, (int)object5);
                }
            }
            catch (Exception exception) {
                componentArray[n].setBounds(0, 0, 0, 0);
            }
            ++n;
        }
    }

    protected ComponentOrientation getComponentOrientation(Container container) {
        ComponentOrientation componentOrientation = null;
        try {
            if (checkForComponentOrientationSupport) {
                methodGetComponentOrientation = Class.forName("java.awt.Container").getMethod("getComponentOrientation", new Class[0]);
            }
            if (methodGetComponentOrientation != null) {
                componentOrientation = (ComponentOrientation)methodGetComponentOrientation.invoke((Object)container, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return componentOrientation;
    }

    protected int[] calculateSizeAndOffset(Entry entry, int n, boolean bl) {
        int n2;
        int[] nArray = bl ? this.crOffset[0] : this.crOffset[1];
        int n3 = bl ? entry.alignment[0] : entry.alignment[1];
        int n4 = bl ? nArray[entry.cr2[0] + 1] - nArray[entry.cr1[0]] : nArray[entry.cr2[1] + 1] - nArray[entry.cr1[1]];
        int n5 = n3 == 2 || n4 < n ? n4 : n;
        if (bl && n3 == 4) {
            n3 = 0;
        }
        if (bl && n3 == 5) {
            n3 = 3;
        }
        switch (n3) {
            case 0: {
                n2 = nArray[bl ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            case 3: {
                n2 = nArray[(bl ? entry.cr2[0] : entry.cr2[1]) + 1] - n5;
                break;
            }
            case 1: {
                n2 = nArray[bl ? entry.cr1[0] : entry.cr1[1]] + (n4 - n5 >> 1);
                break;
            }
            case 2: {
                n2 = nArray[bl ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (bl) {
            n2 += this.hGap * entry.cr1[0];
            n5 += this.hGap * (entry.cr2[0] - entry.cr1[0]);
        } else {
            n2 += this.vGap * entry.cr1[1];
            n5 += this.vGap * (entry.cr2[1] - entry.cr1[1]);
        }
        int[] nArray2 = new int[]{n2, n5};
        return nArray2;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -2.0);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -3.0);
    }

    protected Dimension calculateLayoutSize(Container container, double d) {
        Entry[] entryArray = this.list.toArray(new Entry[this.list.size()]);
        int n = entryArray.length;
        Dimension[] dimensionArray = new Dimension[n];
        int n2 = 0;
        while (n2 < n) {
            dimensionArray[n2] = d == -2.0 ? entryArray[n2].component.getPreferredSize() : entryArray[n2].component.getMinimumSize();
            ++n2;
        }
        n2 = this.calculateLayoutSize(container, 0, d, entryArray, dimensionArray);
        int n3 = this.calculateLayoutSize(container, 1, d, entryArray, dimensionArray);
        Insets insets = container.getInsets();
        return new Dimension(n2 += insets.left + insets.right, n3 += insets.top + insets.bottom);
    }

    protected int calculateLayoutSize(Container container, int n, double d, Entry[] entryArray, Dimension[] dimensionArray) {
        int n2 = 0;
        int n3 = this.crSpec[n].length;
        double d2 = 1.0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            if (this.crSpec[n][n5] > 0.0 && this.crSpec[n][n5] < 1.0) {
                d2 -= this.crSpec[n][n5];
            } else if (this.crSpec[n][n5] == -1.0) {
                ++n4;
            }
            ++n5;
        }
        if (n4 > 1) {
            d2 /= (double)n4;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.crSize[n] = new int[n3];
        this.assignAbsoluteSize(n, 0);
        this.assignPrefMinSize(n, 0, d);
        int[] nArray = new int[n3];
        n5 = 0;
        while (n5 < n3) {
            if (this.crSpec[n][n5] == -2.0 || this.crSpec[n][n5] == -3.0) {
                nArray[n5] = this.crSize[n][n5];
            }
            ++n5;
        }
        int n6 = this.crSpec[0].length;
        int n7 = this.crSpec[1].length;
        int n8 = entryArray.length;
        int n9 = 0;
        while (n9 < n8) {
            Entry entry = entryArray[n9];
            if (entry.cr1[0] >= 0 && entry.cr1[0] < n6 && entry.cr2[0] < n6 && entry.cr1[1] >= 0 && entry.cr1[1] < n7 && entry.cr2[1] < n7) {
                Dimension dimension = dimensionArray[n9];
                int n10 = n == 0 ? dimension.width : dimension.height;
                n5 = entry.cr1[n];
                while (n5 <= entry.cr2[n]) {
                    if (this.crSpec[n][n5] >= 1.0) {
                        n10 = (int)((double)n10 - this.crSpec[n][n5]);
                    } else if (this.crSpec[n][n5] == -2.0 || this.crSpec[n][n5] == -3.0) {
                        n10 -= nArray[n5];
                    }
                    ++n5;
                }
                double d3 = 0.0;
                n5 = entry.cr1[n];
                while (n5 <= entry.cr2[n]) {
                    if (this.crSpec[n][n5] > 0.0 && this.crSpec[n][n5] < 1.0) {
                        d3 += this.crSpec[n][n5];
                    } else if (this.crSpec[n][n5] == -1.0 && d2 != 0.0) {
                        d3 += d2;
                    }
                    ++n5;
                }
                int n11 = d3 == 0.0 ? 0 : (int)((double)n10 / d3 + 0.5);
                if (n2 < n11) {
                    n2 = n11;
                }
            }
            ++n9;
        }
        n9 = n2;
        n5 = 0;
        while (n5 < n3) {
            if (this.crSpec[n][n5] >= 1.0) {
                n9 += (int)(this.crSpec[n][n5] + 0.5);
            } else if (this.crSpec[n][n5] == -2.0 || this.crSpec[n][n5] == -3.0) {
                n9 += nArray[n5];
            }
            ++n5;
        }
        if (n3 > 0) {
            n9 += (n == 0 ? this.hGap : this.vGap) * (n3 - 1);
        }
        return n9;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new TableLayoutConstraints((String)object);
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else if (object instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.remove();
        }
        this.dirty = true;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    public static class Entry
    implements Cloneable {
        public Component component;
        public int[] cr1;
        public int[] cr2;
        public int[] alignment;

        public Entry(Component component, TableLayoutConstraints tableLayoutConstraints) {
            int[] nArray = new int[]{tableLayoutConstraints.col1, tableLayoutConstraints.row1};
            int[] nArray2 = new int[]{tableLayoutConstraints.col2, tableLayoutConstraints.row2};
            int[] nArray3 = new int[]{tableLayoutConstraints.hAlign, tableLayoutConstraints.vAlign};
            this.cr1 = nArray;
            this.cr2 = nArray2;
            this.alignment = nArray3;
            this.component = component;
        }

        public Object copy() throws CloneNotSupportedException {
            return this.clone();
        }

        public String toString() {
            TableLayoutConstraints tableLayoutConstraints = new TableLayoutConstraints(this.cr1[0], this.cr1[1], this.cr2[0], this.cr2[1], this.alignment[0], this.alignment[1]);
            return "(" + tableLayoutConstraints + ") " + this.component;
        }
    }
}

