/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.draggable.DraggableComponentBoxAdapter;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanelProperties;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.internal.TabbedHoverUtil;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TabbedPanelContentPanel
extends BaseContainer {
    private TabbedPanel tabbedPanel;
    private HoverableShapedPanel shapedPanel;
    private ComponentPaintChecker repaintChecker;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            Map map2 = (Map)map.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getMap());
            if (map2 != null && map2.keySet().contains(TabbedPanelContentPanelProperties.HOVER_LISTENER)) {
                HoverListener hoverListener = TabbedPanelContentPanel.this.shapedPanel.getHoverListener();
                TabbedPanelContentPanel.this.shapedPanel.setHoverListener((HoverListener)((ValueChange)map2.get(TabbedPanelContentPanelProperties.HOVER_LISTENER)).getNewValue());
            }
            if ((map2 = (Map)map.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getComponentProperties().getMap())) != null) {
                TabbedPanelContentPanel.this.update();
            }
            if ((map2 = (Map)map.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getShapedPanelProperties().getMap())) != null) {
                TabbedPanelContentPanel.this.update();
            }
            if ((map2 = (Map)map.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getMap())) != null && map2.keySet().contains(TabbedPanelProperties.TAB_AREA_ORIENTATION)) {
                TabbedPanelContentPanel.this.shapedPanel.setDirection(((Direction)((ValueChange)map2.get(TabbedPanelProperties.TAB_AREA_ORIENTATION)).getNewValue()).getNextCW());
            }
        }
    };

    public TabbedPanelContentPanel(TabbedPanel tabbedPanel, JComponent jComponent) {
        super(new BorderLayout());
        this.tabbedPanel = tabbedPanel;
        this.shapedPanel = new HoverableShapedPanel(new BorderLayout(), tabbedPanel.getProperties().getContentPanelProperties().getHoverListener(), tabbedPanel){

            public boolean acceptHover(ArrayList arrayList) {
                return TabbedHoverUtil.acceptTabbedPanelHover(TabbedPanelContentPanel.this.getTabbedPanel().getProperties().getHoverPolicy(), arrayList, TabbedPanelContentPanel.this.getTabbedPanel(), this);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                if (TabbedPanelContentPanel.this.getTabbedPanel().hasContentArea()) {
                    TabbedPanelContentPanel.this.getTabbedPanel().doProcessMouseEvent(mouseEvent);
                } else {
                    TabbedPanelContentPanel.this.doProcessMouseEvent(SwingUtilities.convertMouseEvent(this, mouseEvent, TabbedPanelContentPanel.this));
                }
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                super.processMouseMotionEvent(mouseEvent);
                if (TabbedPanelContentPanel.this.getTabbedPanel().hasContentArea()) {
                    TabbedPanelContentPanel.this.getTabbedPanel().doProcessMouseMotionEvent(mouseEvent);
                } else {
                    TabbedPanelContentPanel.this.doProcessMouseMotionEvent(SwingUtilities.convertMouseEvent(this, mouseEvent, TabbedPanelContentPanel.this));
                }
            }
        };
        this.repaintChecker = new ComponentPaintChecker(this.shapedPanel);
        this.shapedPanel.add((Component)jComponent, "Center");
        this.add((Component)this.shapedPanel, "Center");
        this.update();
        PropertyMapWeakListenerManager.addWeakTreeListener(tabbedPanel.getProperties().getMap(), this.propertiesListener);
        tabbedPanel.getDraggableComponentBox().addListener(new DraggableComponentBoxAdapter(){

            public void changed(DraggableComponentBoxEvent draggableComponentBoxEvent) {
                if (draggableComponentBoxEvent.getDraggableComponent() == null || draggableComponentBoxEvent.getDraggableComponentEvent().getType() == -1) {
                    TabbedPanelContentPanel.this.repaintBorder();
                }
            }
        });
        tabbedPanel.addTabListener(new TabAdapter(){

            public void tabAdded(TabEvent tabEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabDeselected(TabStateChangedEvent tabStateChangedEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabDehighlighted(TabStateChangedEvent tabStateChangedEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabHighlighted(TabStateChangedEvent tabStateChangedEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            public void tabMoved(TabEvent tabEvent) {
                TabbedPanelContentPanel.this.repaintBorder();
            }
        });
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public TabbedPanelContentPanelProperties getProperties() {
        return this.tabbedPanel.getProperties().getContentPanelProperties();
    }

    private void update() {
        this.getProperties().getComponentProperties().applyTo(this.shapedPanel);
        InternalPropertiesUtil.applyTo(this.getProperties().getShapedPanelProperties(), this.shapedPanel, this.tabbedPanel.getProperties().getTabAreaOrientation().getNextCW());
        BaseContainerUtil.setForcedOpaque(this, this.getProperties().getShapedPanelProperties().getOpaque());
    }

    private void repaintBorder() {
        if (this.repaintChecker.isPaintingOk()) {
            Direction direction = this.tabbedPanel.getProperties().getTabAreaOrientation();
            Rectangle rectangle = direction == Direction.UP ? new Rectangle(0, 0, this.shapedPanel.getWidth(), this.shapedPanel.getInsets().top) : (direction == Direction.LEFT ? new Rectangle(0, 0, this.shapedPanel.getInsets().left, this.shapedPanel.getHeight()) : (direction == Direction.DOWN ? new Rectangle(0, this.shapedPanel.getHeight() - this.shapedPanel.getInsets().bottom - 1, this.shapedPanel.getWidth(), this.shapedPanel.getHeight()) : new Rectangle(this.shapedPanel.getWidth() - this.shapedPanel.getInsets().right - 1, 0, this.shapedPanel.getWidth(), this.shapedPanel.getHeight())));
            this.shapedPanel.repaint(rectangle);
        }
    }

    private void doProcessMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    private void doProcessMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(mouseEvent);
    }
}

