/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.xml.sax.SAXException;

public class XmlParser {
    protected Digester digester;
    protected boolean validating = false;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 1.1//EN", "/org/apache/struts/resources/tiles-config_1_1.dtd"};

    public XmlParser() {
        this.digester = new Digester();
        this.digester.setValidating(this.validating);
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(true);
        for (int i = 0; i < this.registrations.length; i += 2) {
            URL url = this.getClass().getResource(this.registrations[i + 1]);
            if (url == null) continue;
            this.digester.register(this.registrations[i], url.toString());
        }
        this.initDigester(this.digester);
    }

    public void setValidating(boolean validating) {
        this.digester.setValidating(validating);
    }

    private void initDigesterForComponentsDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String DEFINITION_TAG = "component-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = DEFINITION_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "putDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String DEFINITION_TAG = "tiles-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = "putList";
        String DEF_LIST_TAG = DEFINITION_TAG + "/" + LIST_TAG;
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = "*/" + LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "putDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(DEF_LIST_TAG, listHandlerClass);
        digester.addSetProperties(DEF_LIST_TAG);
        digester.addSetNext(DEF_LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
        String NESTED_LIST = "*/" + LIST_TAG + "/" + LIST_TAG;
        digester.addObjectCreate(NESTED_LIST, listHandlerClass);
        digester.addSetProperties(NESTED_LIST);
        digester.addSetNext(NESTED_LIST, "add", putAttributeHandlerClass);
        String ADD_WILDCARD = "*/item";
        String menuItemDefaultClass = "org.apache.struts.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(ADD_WILDCARD, menuItemDefaultClass, "classtype");
        digester.addSetNext(ADD_WILDCARD, "add", "java.lang.Object");
        digester.addSetProperties(ADD_WILDCARD);
        String BEAN_TAG = "*/bean";
        String beanDefaultClass = "org.apache.struts.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(BEAN_TAG, beanDefaultClass, "classtype");
        digester.addSetNext(BEAN_TAG, "add", "java.lang.Object");
        digester.addSetProperties(BEAN_TAG);
        digester.addSetProperty(BEAN_TAG + "/set-property", "property", "value");
    }

    private void initDigesterForInstancesSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String INSTANCE_TAG = "component-instances/instance";
        String instanceHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = INSTANCE_TAG + "/put";
        String PUTATTRIBUTE_TAG = INSTANCE_TAG + "/putAttribute";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = INSTANCE_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(INSTANCE_TAG, instanceHandlerClass);
        digester.addSetProperties(INSTANCE_TAG);
        digester.addSetNext(INSTANCE_TAG, "putDefinition", instanceHandlerClass);
        digester.addObjectCreate(PUTATTRIBUTE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUTATTRIBUTE_TAG);
        digester.addSetNext(PUTATTRIBUTE_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
    }

    protected void initDigester(Digester digester) {
        this.initDigesterForTilesDefinitionsSyntax(digester);
        this.initDigesterForComponentsDefinitionsSyntax(digester);
        this.initDigesterForInstancesSyntax(digester);
    }

    public void parse(InputStream in, XmlDefinitionsSet definitions) throws IOException, SAXException {
        this.digester.push((Object)definitions);
        this.digester.parse(in);
        in.close();
    }

    public static void main(String[] args) {
        String filename = "E:/programs/jakarta-tomcat-4.0.3/webapps/wtiles-struts/WEB-INF/tiles-examples-defs.xml";
        if (args.length > 1) {
            filename = args[1];
        }
        System.out.println("Read file '" + filename + "'");
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (IOException ex) {
            System.out.println("can't open file '" + filename + "' : " + ex.getMessage());
        }
        try {
            XmlParser parser = new XmlParser();
            parser.setValidating(true);
            XmlDefinitionsSet definitions = new XmlDefinitionsSet();
            System.out.println("  Parse file");
            parser.parse(input, definitions);
            System.out.println("  done.");
            System.out.println("  Result : " + definitions.toString());
        }
        catch (Exception ex) {
            System.out.println("Error during parsing '" + filename + "' : " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

