#ifndef GAMEPROFILE_H
#define GAMEPROFILE_H

#include <QtGui>


struct ItemInfo
{
  ItemInfo() :
      totalCount(0), localCount(0)
  {
  }

  int totalCount, localCount;
};

struct LevelPackInfo
{
  LevelPackInfo(const QString &s) :
      levelpack(s),
      diff(2), mode(0),
      score(0), localScore(0), level(1),
      time_bonus(0), speed_bonus(0), score_bonus(0), speed_mag_bonus(2),
      next_tool(2)  { }

  void init();

  bool isPuzzle() { return mode == 1; }

  QString levelpack;
  int diff, mode;

  // game progress
  int score, localScore, level;
  int time_bonus, speed_bonus, score_bonus, speed_mag_bonus;
  int next_tool;

  QList<ItemInfo> items;
};

struct PlayerInfo
{
    PlayerInfo(const QString &s) :
        name(s), theme("default"),
        currentlevelpack("default"),
        m_fullscreen(false), m_windowed(false),
        musicEnabled(false), soundVolume(64), musicVolume(64),
        x(0), y(0)
        { addLevelPack("default"); }

    LevelPackInfo* currentLevelPackInfo();

    void addLevelPack(const QString &levelpack);
    void addLevelPack(LevelPackInfo* lpi);
    void setCurrentLevelPack(const QString &levelpack)
    { addLevelPack(levelpack); currentlevelpack = levelpack; }

    QString name, theme;
    QString currentlevelpack; // levelpack

    // settings
    bool m_fullscreen, m_windowed;
    bool musicEnabled;
    int soundVolume, musicVolume;
    int x, y;

    QList<LevelPackInfo*> levelpacks;
};

struct PlayerScore
{
  PlayerScore(const QString &s, int _score) :
      name(s), score(_score)  { }

  QString name;
  int score;
};


class GameProfile : public QObject
{
  Q_OBJECT

public:
    GameProfile(QObject *parent);

    PlayerInfo *currentPlayer();
    void setCurrentPlayer(const QString &name);
    void removePlayer(const QString &name);
    void renamePlayer(const QString &before, const QString &after);

    void saveProfile();
    void loadProfile();

    void loadOldProfile();   // for backward compability

    void saveXml();
    void loadXml();
    void readXmlUnknownElement(QXmlStreamReader &xsr);
    void readXmlPlayer(QXmlStreamReader &xsr);
    void readXmlLevelPack(QXmlStreamReader &xsr, PlayerInfo *pl);
    void readXmlLevelItem(QXmlStreamReader &xsr, LevelPackInfo *lpi);

    void setPlayerNames(const QStringList &sl);
    QStringList playerNames();

    void setGameStarted(bool yes = true) { m_started = yes; }
    bool isGameStarted()                 { return m_started; }

    void setGamePaused(bool yes = true)  { m_paused = yes; }
    bool isGamePaused()                  { return m_paused; }

    void scanThemes();
    QStringList themesList()             { return m_themes; }

    void setCurrentTheme(const QString &_theme)  { currentPlayer()->theme = _theme; }
    QString currentTheme()               { return currentPlayer()->theme; }

    void setCurrentLevelPack(const QString &_lp)  { currentPlayer()->setCurrentLevelPack(_lp); }
    QString currentLevelPack()           { return currentPlayer()->currentlevelpack; }
    int levelPackCount(const QString &lp);

    void setFullscreen(bool yes = true)  { currentPlayer()->m_fullscreen = yes; }
    bool isFullscreen()                  { return currentPlayer()->m_fullscreen; }

    void setWindowed(bool yes = true)    { currentPlayer()->m_windowed = yes; }
    bool isWindowed()                    { return currentPlayer()->m_windowed; }

    void setAccelerated(bool yes = true)    { m_accel = yes; }
    bool isAccelerated()                    { return m_accel; }

//    void addTopTenPlayer(PlayerScore ps);
//  QList<PlayerScore> topTenList()      { return m_topten; }

signals:
  void profileChanged();

private:
    void saveTopTen();
    void loadTopTen();

    int m_current;
    QList<PlayerInfo*> m_players;
//    QList<PlayerScore> m_topten;
    QStringList m_themes;
    QString userPath;

    bool m_started, m_paused, m_accel;
};

extern GameProfile* gameProfile;

#endif // GAMEPROFILE_H
