#ifndef DISPLAYWRAPPER_H
#define DISPLAYWRAPPER_H

#include <QtGui>

#ifdef Q_OS_WIN32
#include <Windows.h>
#else
#include <X11/Xlib.h>
#include <X11/extensions/Xrandr.h>
#include <QX11Info>
#endif


class DisplayWrapper
{
public:
  DisplayWrapper();
  ~DisplayWrapper();

  static bool switchVideoMode(int w, int h, int bpp, bool fs)
  { return DisplayWrapper::dwrapper.dw_switchMode(w,h,bpp,fs); }

  static void restoreVideoMode()
  { DisplayWrapper::dwrapper.dw_restoreMode(); }

private:
  bool dw_switchMode(int w, int h, int bpp, bool fs);
  void dw_restoreMode();

  static DisplayWrapper dwrapper;

  int base_width, base_height, base_bpp;

#ifdef Q_OS_WIN32
  QList<QString> modeNames;
  QList<DEVMODE> modes;
#else
#endif
};

#endif // DISPLAYWRAPPER_H
