/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.internal.Buffer;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;

public final class BooleanHandler
extends PrimitiveHandler {
    static final int LENGTH = 1;
    private static final byte TRUE = 84;
    private static final byte FALSE = 70;
    private static final byte NULL = 78;
    private static final Boolean i_primitive = new Boolean(false);
    private boolean i_compareTo;

    public BooleanHandler(InternalObjectContainer internalObjectContainer) {
        super(internalObjectContainer);
    }

    public Object defaultValue() {
        return i_primitive;
    }

    public int linkLength() {
        return 1;
    }

    protected Class primitiveJavaClass() {
        return Boolean.TYPE;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    Object read1(Buffer buffer) {
        byte by = buffer.readByte();
        if (by == 84) {
            return new Boolean(true);
        }
        if (by == 70) {
            return new Boolean(false);
        }
        return null;
    }

    public void write(Object object, Buffer buffer) {
        buffer.writeByte(this.getEncodedByteValue(object));
    }

    private byte getEncodedByteValue(Object object) {
        if (object == null) {
            return 78;
        }
        if (((Boolean)object).booleanValue()) {
            return 84;
        }
        return 70;
    }

    private boolean val(Object object) {
        return (Boolean)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    boolean isEqual1(Object object) {
        return object instanceof Boolean && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        if (this.i_compareTo) {
            return false;
        }
        return object instanceof Boolean && this.val(object);
    }

    boolean isSmaller1(Object object) {
        if (!this.i_compareTo) {
            return false;
        }
        return object instanceof Boolean && !this.val(object);
    }

    public Object read(ReadContext readContext) {
        byte by = readContext.readByte();
        if (by == 84) {
            return new Boolean(true);
        }
        if (by == 70) {
            return new Boolean(false);
        }
        return null;
    }

    public void write(WriteContext writeContext, Object object) {
        writeContext.writeByte(this.getEncodedByteValue(object));
    }

    public Object nullRepresentationInUntypedArrays() {
        return null;
    }
}

