/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4oIOException;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientTransactionHandle;
import com.db4o.internal.cs.LazyClientObjectSetStub;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MSwitchToFile;
import com.db4o.internal.cs.messages.MUseTransaction;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.ServerSideMessage;

public final class ServerMessageDispatcherImpl
extends Thread
implements ServerMessageDispatcher {
    private String _clientName;
    private boolean _loggedin;
    private boolean _closeMessageSent;
    private final ObjectServerImpl _server;
    private Socket4 _socket;
    private ClientTransactionHandle _transactionHandle;
    private Hashtable4 _queryResults;
    final int _threadID;
    private CallbackObjectInfoCollections _committedInfo;
    private boolean _caresAboutCommitted;
    private boolean _isClosed;
    private final Object _lock = new Object();
    private final Object _mainLock;

    ServerMessageDispatcherImpl(ObjectServerImpl objectServerImpl, ClientTransactionHandle clientTransactionHandle, Socket4 socket4, int n, boolean bl, Object object) throws Exception {
        this._mainLock = object;
        this._transactionHandle = clientTransactionHandle;
        this.setDaemon(true);
        this._loggedin = bl;
        this._server = objectServerImpl;
        this._threadID = n;
        this.setDispatcherName("" + n);
        this._socket = socket4;
        this._socket.setSoTimeout(((Config4Impl)objectServerImpl.configure()).timeoutServerSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return true;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction();
            this.sendCloseMessage();
            this._transactionHandle.close();
            this.closeSocket();
            this.removeFromServer();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this.closeSocket();
            this.removeFromServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageDispatcherAlive() {
        Object object = this._lock;
        synchronized (object) {
            return !this._isClosed;
        }
    }

    private void sendCloseMessage() {
        try {
            if (!this._closeMessageSent) {
                this._closeMessageSent = true;
                this.write(Msg.CLOSE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromServer() {
        try {
            this._server.removeThread(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocket() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (Db4oIOException db4oIOException) {
            // empty catch block
        }
    }

    public Transaction getTransaction() {
        return this._transactionHandle.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.messageLoop();
        }
        finally {
            this.close();
        }
    }

    private void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            try {
                if (this.messageProcessor()) continue;
                return;
            }
            catch (Db4oIOException db4oIOException) {
                return;
            }
        }
    }

    private boolean messageProcessor() throws Db4oIOException {
        Msg msg = Msg.readMessage(this, this.getTransaction(), this._socket);
        if (msg == null) {
            return true;
        }
        if (!this._loggedin && !Msg.LOGIN.equals(msg)) {
            return true;
        }
        if (this.isMessageDispatcherAlive()) {
            return ((ServerSideMessage)((Object)msg)).processAtServer();
        }
        return false;
    }

    public ObjectServerImpl server() {
        return this._server;
    }

    public void queryResultFinalized(int n) {
        this._queryResults.remove(n);
    }

    public void mapQueryResultToID(LazyClientObjectSetStub lazyClientObjectSetStub, int n) {
        if (this._queryResults == null) {
            this._queryResults = new Hashtable4();
        }
        this._queryResults.put(n, (Object)lazyClientObjectSetStub);
    }

    public LazyClientObjectSetStub queryResultForID(int n) {
        return (LazyClientObjectSetStub)this._queryResults.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(MSwitchToFile mSwitchToFile) {
        Object object = this._mainLock;
        synchronized (object) {
            String string = mSwitchToFile.readString();
            try {
                this._transactionHandle.releaseTransaction();
                this._transactionHandle.acquireTransactionForFile(string);
                this.write(Msg.OK);
            }
            catch (Exception exception) {
                this._transactionHandle.releaseTransaction();
                this.write(Msg.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction();
            this.write(Msg.OK);
        }
    }

    public void useTransaction(MUseTransaction mUseTransaction) {
        int n = mUseTransaction.readInt();
        Transaction transaction = this._server.findTransaction(n);
        this._transactionHandle.transaction(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Msg msg) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return false;
            }
            return msg.write(this._socket);
        }
    }

    public Socket4 socket() {
        return this._socket;
    }

    public String name() {
        return this._clientName;
    }

    public void setDispatcherName(String string) {
        this._clientName = string;
        this.setName("db4o server message dispatcher " + string);
    }

    public int dispatcherID() {
        return this._threadID;
    }

    public void login() {
        this._loggedin = true;
    }

    public void startDispatcher() {
        this.start();
    }

    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    public void caresAboutCommitted(boolean bl) {
        this._caresAboutCommitted = true;
        this.server().checkCaresAboutCommitted();
    }

    public CallbackObjectInfoCollections committedInfo() {
        return this._committedInfo;
    }

    public void committedInfo(CallbackObjectInfoCollections callbackObjectInfoCollections) {
        this._committedInfo = callbackObjectInfoCollections;
    }
}

