/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.instrumentation.core.NativeClassFactory;
import com.db4o.nativequery.expr.AndExpression;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.ExpressionVisitor;
import com.db4o.nativequery.expr.NotExpression;
import com.db4o.nativequery.expr.OrExpression;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandAnchor;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.optimization.ComparisonQueryGeneratingVisitor;
import com.db4o.query.Constraint;
import com.db4o.query.Query;

public class SODAQueryBuilder {
    public void optimizeQuery(Expression expression, Query query, Object object, NativeClassFactory nativeClassFactory) {
        expression.accept(new SODAQueryVisitor(query, object, nativeClassFactory));
    }

    private static class SODAQueryVisitor
    implements ExpressionVisitor {
        private Object _predicate;
        private Query _query;
        private Constraint _constraint;
        private NativeClassFactory _classSource;

        SODAQueryVisitor(Query query, Object object, NativeClassFactory nativeClassFactory) {
            this._query = query;
            this._predicate = object;
            this._classSource = nativeClassFactory;
        }

        public void visit(AndExpression andExpression) {
            andExpression.left().accept(this);
            Constraint constraint = this._constraint;
            andExpression.right().accept(this);
            constraint.and(this._constraint);
            this._constraint = constraint;
        }

        public void visit(BoolConstExpression boolConstExpression) {
        }

        public void visit(OrExpression orExpression) {
            orExpression.left().accept(this);
            Constraint constraint = this._constraint;
            orExpression.right().accept(this);
            constraint.or(this._constraint);
            this._constraint = constraint;
        }

        public void visit(ComparisonExpression comparisonExpression) {
            Query query = this._query;
            Iterator4 iterator4 = this.fieldNames(comparisonExpression.left());
            while (iterator4.moveNext()) {
                query = query.descend((String)iterator4.current());
            }
            ComparisonQueryGeneratingVisitor comparisonQueryGeneratingVisitor = new ComparisonQueryGeneratingVisitor(this._predicate, this._classSource);
            comparisonExpression.right().accept(comparisonQueryGeneratingVisitor);
            this._constraint = query.constrain(comparisonQueryGeneratingVisitor.value());
            ComparisonOperator comparisonOperator = comparisonExpression.op();
            if (comparisonOperator.equals(ComparisonOperator.EQUALS)) {
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.IDENTITY)) {
                this._constraint.identity();
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.GREATER)) {
                this._constraint.greater();
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.SMALLER)) {
                this._constraint.smaller();
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.CONTAINS)) {
                this._constraint.contains();
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.STARTSWITH)) {
                this._constraint.startsWith(true);
                return;
            }
            if (comparisonOperator.equals(ComparisonOperator.ENDSWITH)) {
                this._constraint.endsWith(true);
                return;
            }
            throw new RuntimeException("Can't handle constraint: " + comparisonOperator);
        }

        public void visit(NotExpression notExpression) {
            notExpression.expr().accept(this);
            this._constraint.not();
        }

        private Iterator4 fieldNames(FieldValue fieldValue) {
            Collection4 collection4 = new Collection4();
            ComparisonOperandAnchor comparisonOperandAnchor = fieldValue;
            while (comparisonOperandAnchor instanceof FieldValue) {
                FieldValue fieldValue2 = comparisonOperandAnchor;
                collection4.prepend((Object)fieldValue2.fieldName());
                comparisonOperandAnchor = fieldValue2.parent();
            }
            return collection4.iterator();
        }
    }
}

