/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassSource;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.nativequery.analysis.BloatExprBuilderVisitor;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.optimization.SODABloatMethodBuilder;

public class NativeQueryEnhancer {
    public static final String OPTIMIZE_QUERY_METHOD_NAME = "optimizeQuery";
    private static SODABloatMethodBuilder BLOAT_BUILDER = new SODABloatMethodBuilder();

    public boolean enhance(BloatLoaderContext bloatLoaderContext, ClassEditor classEditor, String string, Type[] typeArray, ClassLoader classLoader, ClassSource classSource) throws Exception {
        Expression expression = this.analyze(bloatLoaderContext, classEditor, string, typeArray);
        if (expression == null) {
            return false;
        }
        MethodEditor methodEditor = BLOAT_BUILDER.injectOptimization(expression, classEditor, classLoader, classSource);
        methodEditor.commit();
        classEditor.commit();
        return true;
    }

    public Expression analyze(BloatLoaderContext bloatLoaderContext, ClassEditor classEditor, String string) {
        return this.analyze(bloatLoaderContext, classEditor, string, null);
    }

    public Expression analyze(BloatLoaderContext bloatLoaderContext, ClassEditor classEditor, String string, Type[] typeArray) {
        FlowGraph flowGraph = null;
        try {
            flowGraph = bloatLoaderContext.flowGraph(classEditor, string, typeArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (flowGraph != null) {
            BloatExprBuilderVisitor bloatExprBuilderVisitor = new BloatExprBuilderVisitor(bloatLoaderContext);
            flowGraph.visit(bloatExprBuilderVisitor);
            Expression expression = bloatExprBuilderVisitor.expression();
            return expression;
        }
        return null;
    }
}

