/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tbaa;

import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.util.Assert;

public class TBAA {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canAlias(EditorContext context, Expr a, Expr b) {
        if (!(a instanceof MemRefExpr)) {
            return false;
        }
        if (!(b instanceof MemRefExpr)) {
            return false;
        }
        if (a.equalsExpr(b)) {
            return true;
        }
        MemberRef af = null;
        MemberRef bf = null;
        if (a instanceof FieldExpr) {
            af = ((FieldExpr)a).field();
        }
        if (a instanceof StaticFieldExpr) {
            af = ((StaticFieldExpr)a).field();
        }
        if (b instanceof FieldExpr) {
            bf = ((FieldExpr)b).field();
        }
        if (b instanceof StaticFieldExpr) {
            bf = ((StaticFieldExpr)b).field();
        }
        if (a instanceof ArrayRefExpr && bf != null) {
            return false;
        }
        if (b instanceof ArrayRefExpr && af != null) {
            return false;
        }
        ClassHierarchy hier = context.getHierarchy();
        if (a instanceof ArrayRefExpr && b instanceof ArrayRefExpr) {
            ArrayRefExpr aa = (ArrayRefExpr)a;
            ArrayRefExpr bb = (ArrayRefExpr)b;
            Type aaIndexType = aa.index().type();
            Type bbIndexType = bb.index().type();
            Type aaArrayType = aa.array().type();
            Type bbArrayType = bb.array().type();
            Assert.isTrue(aaIndexType.isIntegral(), aa.index() + " in " + aa + " (" + aaIndexType + ") is not an integer");
            Assert.isTrue(bbIndexType.isIntegral(), bb.index() + " in " + bb + " (" + bbIndexType + ") is not an integer");
            Assert.isTrue(aaArrayType.isArray() || aaArrayType.equals(Type.OBJECT) || aaArrayType.equals(Type.SERIALIZABLE) || aaArrayType.equals(Type.CLONEABLE) || aaArrayType.isNull(), aa.array() + " in " + aa + " (" + aaArrayType + ") is not an array");
            Assert.isTrue(bbArrayType.isArray() || bbArrayType.equals(Type.OBJECT) || bbArrayType.equals(Type.SERIALIZABLE) || bbArrayType.equals(Type.CLONEABLE) || bbArrayType.isNull(), bb.array() + " in " + bb + " (" + bbArrayType + ") is not an array");
            if (aa.index() instanceof ConstantExpr && bb.index() instanceof ConstantExpr) {
                ConstantExpr ai = (ConstantExpr)aa.index();
                ConstantExpr bi = (ConstantExpr)bb.index();
                if (ai.value() != null && bi.value() != null && !ai.value().equals(bi.value())) {
                    return false;
                }
            }
            return TBAA.intersects(hier, aaArrayType, bbArrayType);
        }
        try {
            FieldEditor e;
            if (af != null) {
                e = context.editField(af);
                if (e.isVolatile()) {
                    context.release(e.fieldInfo());
                    return true;
                }
                if (e.isFinal()) {
                    context.release(e.fieldInfo());
                    return false;
                }
                context.release(e.fieldInfo());
            }
            if (bf != null) {
                e = context.editField(bf);
                if (e.isVolatile()) {
                    context.release(e.fieldInfo());
                    return true;
                }
                if (e.isFinal()) {
                    context.release(e.fieldInfo());
                    return false;
                }
                context.release(e.fieldInfo());
            }
        }
        catch (NoSuchFieldException e) {
            return true;
        }
        if (af != null && bf != null) {
            return af.equals(bf);
        }
        return TBAA.intersects(hier, a.type(), b.type());
    }

    private static boolean intersects(ClassHierarchy hier, Type a, Type b) {
        return !hier.intersectType(a, b).isNull();
    }
}

