/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.reflect.LocalDebugInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private LocalDebugInfo[] locals;

    public LocalVariableTable(DataInputStream in, int index, int len) throws IOException {
        super(index, len);
        int numLocals = in.readUnsignedShort();
        this.locals = new LocalDebugInfo[numLocals];
        int i = 0;
        while (i < this.locals.length) {
            int startPC = in.readUnsignedShort();
            int length = in.readUnsignedShort();
            int nameIndex = in.readUnsignedShort();
            int typeIndex = in.readUnsignedShort();
            int varIndex = in.readUnsignedShort();
            this.locals[i] = new LocalDebugInfo(startPC, length, nameIndex, typeIndex, varIndex);
            ++i;
        }
    }

    public LocalDebugInfo[] locals() {
        return this.locals;
    }

    public void setLocals(LocalDebugInfo[] locals) {
        this.locals = locals;
    }

    public int length() {
        return 2 + this.locals.length * 10;
    }

    public String toString() {
        String x = "(locals";
        int i = 0;
        while (i < this.locals.length) {
            x = String.valueOf(x) + "\n          (local @" + this.locals[i].index() + " name=" + this.locals[i].nameIndex() + " type=" + this.locals[i].typeIndex() + " pc=" + this.locals[i].startPC() + ".." + (this.locals[i].startPC() + this.locals[i].length()) + ")";
            ++i;
        }
        return String.valueOf(x) + ")";
    }

    public void writeData(DataOutputStream out) throws IOException {
        out.writeShort(this.locals.length);
        int i = 0;
        while (i < this.locals.length) {
            out.writeShort(this.locals[i].startPC());
            out.writeShort(this.locals[i].length());
            out.writeShort(this.locals[i].nameIndex());
            out.writeShort(this.locals[i].typeIndex());
            out.writeShort(this.locals[i].index());
            ++i;
        }
    }

    private LocalVariableTable(LocalVariableTable other) {
        super(other.nameIndex, other.length);
        this.locals = new LocalDebugInfo[other.locals.length];
        int i = 0;
        while (i < other.locals.length) {
            this.locals[i] = (LocalDebugInfo)other.locals[i].clone();
            ++i;
        }
    }

    public Object clone() {
        return new LocalVariableTable(this);
    }
}

