/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.TransactionEntry;
import jgnash.ui.register.table.AccountTableModel;
import jgnash.ui.register.table.FullCommodityStyle;
import jgnash.ui.register.table.ShortCommodityStyle;
import jgnash.util.Resource;

public class SplitsRegisterTableModel
extends AbstractTableModel
implements AccountTableModel {
    private static final long serialVersionUID = -8915685858944811662L;
    private final Resource rb = Resource.get();
    private String[] cNames = new String[]{this.rb.getString("Column.Account"), this.rb.getString("Column.Clr"), this.rb.getString("Column.Memo"), this.rb.getString("Column.Credit"), this.rb.getString("Column.Debit"), this.rb.getString("Column.Balance")};
    private Class<?>[] cClass = new Class[]{String.class, String.class, String.class, ShortCommodityStyle.class, ShortCommodityStyle.class, FullCommodityStyle.class};
    private Account account;
    private SandBoxSplitTransaction transaction;

    public SplitsRegisterTableModel(Account account, String[] names, List<TransactionEntry> splits) {
        this.account = account;
        this.transaction = new SandBoxSplitTransaction(splits);
        this.cNames = Arrays.copyOf(names, names.length);
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.cNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.cClass[column];
    }

    @Override
    public Object getValueAt(int row, int col) {
        TransactionEntry t = this.transaction.getSplitAt(row);
        Account creditAccount = t.getCreditAccount();
        switch (col) {
            case 0: {
                if (creditAccount != this.account) {
                    return creditAccount.getName();
                }
                return t.getDebitAccount().getName();
            }
            case 1: {
                return t.getReconciled(this.account).toString();
            }
            case 2: {
                return t.getMemo();
            }
            case 3: {
                if (creditAccount == this.account) {
                    return t.getAmount(this.account);
                }
                return null;
            }
            case 4: {
                if (creditAccount != this.account) {
                    return t.getAmount(this.account).abs();
                }
                return null;
            }
            case 5: {
                return this.transaction.getRunningBalance(row + 1);
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.transaction.getNumSplits();
    }

    public void addTransaction(TransactionEntry t) {
        this.transaction.addSplit(t);
        this.fireTableDataChanged();
    }

    public void removeTransaction(int index) {
        this.transaction.removeSplit(index);
        this.fireTableDataChanged();
    }

    public TransactionEntry getTransactionAt(int index) {
        return this.transaction.getSplitAt(index);
    }

    public void modifyTransaction(TransactionEntry oldTrans, TransactionEntry newTrans) {
        this.transaction.replaceSplit(oldTrans, newTrans);
        this.fireTableDataChanged();
    }

    public ArrayList<TransactionEntry> getSplits() {
        return this.transaction.getSplits();
    }

    public BigDecimal getBalance() {
        return this.transaction.getBalance();
    }

    class SandBoxSplitTransaction {
        private ArrayList<TransactionEntry> splits;

        protected SandBoxSplitTransaction(List<TransactionEntry> list) {
            this.splits = list != null ? new ArrayList<TransactionEntry>(list) : new ArrayList();
        }

        public int getNumSplits() {
            return this.splits.size();
        }

        protected TransactionEntry getSplitAt(int index) {
            return this.splits.get(index);
        }

        protected void removeSplit(int index) {
            this.splits.remove(index);
        }

        protected void addSplit(TransactionEntry t) {
            this.splits.add(t);
            Collections.sort(this.splits);
        }

        protected void replaceSplit(TransactionEntry oldTrans, TransactionEntry newTrans) {
            int index = this.splits.indexOf(oldTrans);
            if (index != -1) {
                this.splits.set(index, newTrans);
                Collections.sort(this.splits);
            }
        }

        public ArrayList<TransactionEntry> getSplits() {
            return this.splits;
        }

        protected BigDecimal getRunningBalance(int index) {
            BigDecimal balance = this.getSplitAt(0).getAmount(SplitsRegisterTableModel.this.account);
            for (int i = 1; i < index; ++i) {
                balance = balance.add(this.getSplitAt(i).getAmount(SplitsRegisterTableModel.this.account));
            }
            return balance;
        }

        public BigDecimal getBalance() {
            return this.getRunningBalance(this.getNumSplits());
        }
    }
}

