/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jgnash.ui.UIApplication;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

class ColumnDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JButton addButton;
    private JButton cancelButton;
    private JButton okButton;
    private JButton removeButton;
    private JList showList;
    private JList hideList;
    private SortedListModel<String> showModel;
    private SortedListModel<String> hideModel;
    private AbstractRegisterTableModel model;
    private boolean result = false;

    private ColumnDialog(AbstractRegisterTableModel model) {
        super((Frame)UIApplication.getFrame(), true);
        this.setModal(true);
        this.setTitle(this.rb.getString("Title.ColVis"));
        this.model = model;
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.pack();
        DialogUtils.addBoundsListener(this);
    }

    protected static boolean showDialog(AbstractRegisterTableModel model) {
        ColumnDialog d = new ColumnDialog(model);
        d.setVisible(true);
        return d.result;
    }

    private void initComponents() {
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.addButton = new JButton(this.rb.getString("Button.Add"));
        this.addButton.setIcon(Resource.getIcon("/jgnash/resource/list-add.png"));
        this.addButton.setHorizontalTextPosition(10);
        this.removeButton = new JButton(this.rb.getString("Button.Remove"));
        this.removeButton.setIcon(Resource.getIcon("/jgnash/resource/list-remove.png"));
        String[] names = this.model.getColumnNames();
        this.showModel = new SortedListModel();
        this.hideModel = new SortedListModel();
        for (int i = 0; i < names.length; ++i) {
            if (this.model.isColumnVisible(i)) {
                this.showModel.addElement(names[i]);
                continue;
            }
            this.hideModel.addElement(names[i]);
        }
        this.showList = new JList<String>(this.showModel);
        this.hideList = new JList<String>(this.hideModel);
        this.showList.setPrototypeCellValue("prototypeCellValue");
        this.hideList.setPrototypeCellValue("prototypeCellValue");
        this.addButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("d:g(0.5), 8dlu, p, 8dlu, d:g(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendTitle(this.rb.getString("Title.Available"));
        builder.append("");
        builder.appendTitle(this.rb.getString("Title.Visible"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:80dlu:g"));
        builder.append((Component)new JScrollPane(this.hideList));
        builder.append((Component)this.buildCenterPanel());
        builder.append((Component)new JScrollPane(this.showList));
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 5);
        this.getContentPane().add((Component)builder.getPanel(), "Center");
    }

    private JPanel buildCenterPanel() {
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.addButton);
        builder.append((Component)this.removeButton);
        return builder.getPanel();
    }

    private void commitVisibility() {
        Object[] list;
        for (Object o : list = this.showModel.toArray()) {
            this.model.setColumnVisible((String)o, true);
        }
        for (Object o : list = this.hideModel.toArray()) {
            this.model.setColumnVisible((String)o, false);
        }
    }

    private void okAction() {
        this.result = true;
        this.closeDialog();
        this.commitVisibility();
    }

    private void addAction() {
        Object[] list;
        for (Object o : list = this.hideList.getSelectedValues()) {
            this.hideModel.removeElement((String)o);
            this.showModel.addElement((String)o);
        }
    }

    private void removeAction() {
        Object[] list;
        for (Object o : list = this.showList.getSelectedValues()) {
            this.showModel.removeElement((String)o);
            this.hideModel.addElement((String)o);
        }
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okAction();
        } else if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.addButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        }
    }
}

