/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionType;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AutoCompleteTextField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.autocomplete.AutoCompleteModel;
import jgnash.ui.components.autocomplete.DefaultAutoCompleteModel;
import jgnash.util.MultiHashMap;

public class AutoCompleteFactory {
    private static AutoCompleteModel memoModel;
    private static boolean autoComplete;
    private static final String AUTO_COMPLETE = "autoComplete";

    private AutoCompleteFactory() {
    }

    public static void setEnabled(boolean auto) {
        autoComplete = auto;
        Preferences p = Preferences.userNodeForPackage(AutoCompleteFactory.class);
        p.putBoolean(AUTO_COMPLETE, autoComplete);
    }

    public static boolean isEnabled() {
        return autoComplete;
    }

    public static JTextField getMemoField() {
        if (autoComplete) {
            if (memoModel == null) {
                memoModel = new MemoModel();
            }
            return new AutoCompleteTextField(memoModel);
        }
        return new JTextFieldEx();
    }

    public static JTextField getPayeeField(Account account) {
        if (autoComplete) {
            return new AutoCompleteTextField(new PayeeAccountModel(account));
        }
        return new JTextFieldEx();
    }

    static {
        autoComplete = true;
        Preferences p = Preferences.userNodeForPackage(AutoCompleteFactory.class);
        autoComplete = p.getBoolean(AUTO_COMPLETE, true);
    }

    private static class PayeeModel
    extends TransactionModel {
        MultiHashMap<String, Transaction> transactions = new MultiHashMap();

        private PayeeModel() {
        }

        @Override
        void load(Transaction tran) {
            String payee;
            if (tran != null && tran.getTransactionType() != TransactionType.SPLITENTRY && (payee = tran.getPayee()) != null) {
                this.addString(tran.getPayee());
                this.transactions.put(tran.getPayee(), (Object)tran);
            }
        }

        @Override
        public Object getExtraInfo(String key) {
            return this.transactions.get(key);
        }

        void removeExtraInfo(Transaction t) {
            this.transactions.remove(t.getPayee(), t);
        }

        @Override
        public void messagePosted(Message event) {
            super.messagePosted(event);
            switch (event.getEvent()) {
                case TRANSACTION_REMOVE: {
                    this.removeExtraInfo((Transaction)event.getObject(MessageProperty.TRANSACTION));
                    return;
                }
            }
        }
    }

    private static class PayeeAccountModel
    extends PayeeModel {
        private Account account;

        public PayeeAccountModel(Account account) {
            this.account = account;
            this.load();
        }

        @Override
        void load() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (PayeeAccountModel.this.account != null) {
                                for (Transaction t : PayeeAccountModel.this.account.getTransactions()) {
                                    PayeeAccountModel.this.load(t);
                                }
                            }
                        }
                    }).start();
                }
            });
        }

        @Override
        public void messagePosted(Message event) {
            Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
            switch (event.getEvent()) {
                case TRANSACTION_ADD: {
                    if (a.equals(this.account)) {
                        this.load(t);
                    }
                    return;
                }
                case FILE_NEW_SUCCESS: {
                    this.purge();
                    return;
                }
                case FILE_LOAD_SUCCESS: {
                    this.purge();
                    this.load();
                    return;
                }
                case TRANSACTION_REMOVE: {
                    if (a.equals(this.account)) {
                        this.removeExtraInfo(t);
                    }
                    return;
                }
            }
        }
    }

    private static class MemoModel
    extends PayeeModel {
        private MemoModel() {
        }

        @Override
        void load(Transaction tran) {
            if (tran != null) {
                this.addString(tran.getMemo());
            }
        }
    }

    private static abstract class TransactionModel
    extends DefaultAutoCompleteModel
    implements MessageListener {
        volatile boolean load = false;

        public TransactionModel() {
            MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
            MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
            this.load();
        }

        @Override
        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case TRANSACTION_ADD: {
                    Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                    this.load(t);
                    return;
                }
                case FILE_NEW_SUCCESS: {
                    this.purge();
                    return;
                }
                case FILE_LOAD_SUCCESS: {
                    this.purge();
                    this.load();
                    return;
                }
                case FILE_CLOSING: {
                    this.load = false;
                    return;
                }
            }
        }

        void load() {
            this.load = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList<Transaction> transactions = new ArrayList<Transaction>(EngineFactory.getEngine("default").getTransactions());
                        Collections.sort(transactions);
                        for (Transaction t : transactions) {
                            if (TransactionModel.this.load) {
                                TransactionModel.this.load(t);
                                continue;
                            }
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }

        abstract void load(Transaction var1);
    }
}

