/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.text.CommodityFormat;
import jgnash.ui.UIApplication;
import jgnash.ui.components.FormattedJTable;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class TransactionListDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private final Resource rb = Resource.get();
    private final String PRINT = this.rb.getString("Item.Print");
    private Model model = null;
    private boolean returnStatus = false;
    private JTable table;
    private JButton cancelButton;
    private JButton clearButton;
    private JButton invertButton;
    private JButton okButton;
    private JButton selectButton;

    public TransactionListDialog() {
        super((Frame)UIApplication.getFrame(), true);
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.setLocationRelativeTo(UIApplication.getFrame());
    }

    private void initComponents() {
        this.setTitle(this.rb.getString("Title.TransactionList"));
        this.selectButton = new JButton(this.rb.getString("Button.SelectAll"));
        this.clearButton = new JButton(this.rb.getString("Button.ClearAll"));
        this.invertButton = new JButton(this.rb.getString("Button.InvertSelection"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.model = new Model(this._getPrintableTransactions());
        this.table = new FormattedJTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.invertButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendTitle(this.rb.getString("Message.TransToPrint"));
        builder.append((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.selectButton, (JButton)this.clearButton, (JButton)this.invertButton));
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:75dlu:g"));
        builder.append((Component)new JScrollPane(this.table));
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
        this.table.getSelectionModel().removeListSelectionListener(this);
        this.table = null;
    }

    private List<Transaction> _getPrintableTransactions() {
        ArrayList<Transaction> l = new ArrayList<Transaction>();
        for (Transaction t : EngineFactory.getEngine("default").getTransactions()) {
            if (!this.PRINT.equalsIgnoreCase(t.getNumber())) continue;
            l.add(t);
        }
        Collections.sort(l);
        return l;
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public List<Transaction> getPrintableTransactions() {
        return this.model.getPrintableTransactions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.returnStatus = true;
            this.closeDialog();
        } else if (e.getSource() == this.cancelButton) {
            this.returnStatus = false;
            this.closeDialog();
        } else if (e.getSource() == this.clearButton) {
            this.model.clearAll();
        } else if (e.getSource() == this.selectButton) {
            this.model.selectAll();
        } else if (e.getSource() == this.invertButton) {
            this.model.invertAll();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.table.getSelectionModel() && (i = this.table.getSelectedRow()) >= 0) {
            Wrapper w = this.model.getWrapperAt(i);
            w.print = !w.print;
            this.model.fireTableRowsUpdated(i, i);
            this.table.clearSelection();
        }
    }

    static /* synthetic */ Resource access$000(TransactionListDialog x0) {
        return x0.rb;
    }

    private static final class Wrapper {
        Transaction transaction;
        boolean print;

        protected Wrapper(Transaction t) {
            assert (t != null);
            this.transaction = t;
        }
    }

    private class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 6665735758964949493L;
        private final ArrayList<Wrapper> wrapperList = new ArrayList();
        private final String[] columnNames = new String[]{TransactionListDialog.access$000(TransactionListDialog.this).getString("Column.Print"), TransactionListDialog.access$000(TransactionListDialog.this).getString("Column.Date"), TransactionListDialog.access$000(TransactionListDialog.this).getString("Column.Payee"), TransactionListDialog.access$000(TransactionListDialog.this).getString("Column.Account"), TransactionListDialog.access$000(TransactionListDialog.this).getString("Column.Amount")};
        private DateFormat dateFormatter = DateUtils.getShortDateFormat();
        private CommodityFormat commodityformat = CommodityFormat.getFullFormat();

        protected Model(List<Transaction> list) {
            for (Transaction t : list) {
                this.wrapperList.add(new Wrapper(t));
            }
        }

        @Override
        public String getColumnName(int c) {
            return this.columnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 4) {
                return BigDecimal.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.wrapperList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Wrapper w = this.wrapperList.get(rowIndex);
            Account baseAccount = w.transaction.getTransactionEntries().size() > 1 ? w.transaction.getCommonAccount() : w.transaction.getTransactionEntries().get(0).getDebitAccount();
            switch (columnIndex) {
                case 0: {
                    if (w.print) {
                        return "\u2713";
                    }
                    return null;
                }
                case 1: {
                    return this.dateFormatter.format(w.transaction.getDate());
                }
                case 2: {
                    return w.transaction.getPayee();
                }
                case 3: {
                    return baseAccount.getName();
                }
                case 4: {
                    return this.commodityformat.format(w.transaction.getAmount(baseAccount).abs(), baseAccount.getCurrencyNode());
                }
            }
            return null;
        }

        protected Wrapper getWrapperAt(int i) {
            return this.wrapperList.get(i);
        }

        public List<Transaction> getPrintableTransactions() {
            ArrayList<Transaction> list = new ArrayList<Transaction>();
            for (Wrapper w : this.wrapperList) {
                if (!w.print) continue;
                list.add(w.transaction);
            }
            return list;
        }

        protected void clearAll() {
            int size = this.wrapperList.size();
            for (int i = 0; i < size; ++i) {
                this.getWrapperAt((int)i).print = false;
            }
            this.fireTableDataChanged();
        }

        protected void selectAll() {
            int size = this.wrapperList.size();
            for (int i = 0; i < size; ++i) {
                this.getWrapperAt((int)i).print = true;
            }
            this.fireTableDataChanged();
        }

        protected void invertAll() {
            int size = this.wrapperList.size();
            for (int i = 0; i < size; ++i) {
                this.getWrapperAt((int)i).print = !this.getWrapperAt((int)i).print;
            }
            this.fireTableDataChanged();
        }
    }
}

