/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.AccountTreeXMLFactory;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.util.Resource;

public class ImportAccountsAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = -2708791260270035876L;
    private static final String ACCOUNTSIMPORTDIR = "AccountsImportDirectroy";

    private static void importAccounts() {
        Preferences pref = Preferences.userNodeForPackage(ImportAccountsAction.class);
        Resource rb = Resource.get();
        JFileChooser chooser = new JFileChooser(pref.get(ACCOUNTSIMPORTDIR, null));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(rb.getString("Label.XMLFiles") + " (*.xml)", "xml"));
        if (chooser.showOpenDialog(null) == 0) {
            File file = chooser.getSelectedFile();
            pref.put(ACCOUNTSIMPORTDIR, chooser.getCurrentDirectory().getAbsolutePath());
            final class Import
            extends SwingWorker<Void, Void> {
                final /* synthetic */ File val$file;

                Import(File file) {
                    this.val$file = file;
                }

                @Override
                protected Void doInBackground() throws Exception {
                    UIApplication.getFrame().displayWaitMessage(Resource.get().getString("Message.ImportWait"));
                    RootAccount root = AccountTreeXMLFactory.loadAccountTree(this.val$file);
                    if (root != null) {
                        AccountTreeXMLFactory.mergeAccountTree(EngineFactory.getEngine("default"), root);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    UIApplication.getFrame().stopWaitMessage();
                }
            }
            new Import(file).execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImportAccountsAction.importAccounts();
    }
}

