/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.account.AccountFilterModel;
import jgnash.ui.account.ExpandingAccountTableNode;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.util.Resource;

public class ExpandingAccountTableModel
extends AbstractTableModel
implements AccountFilterModel {
    private Map<Account, ExpandingAccountTableNode> accounts = new HashMap<Account, ExpandingAccountTableNode>();
    private boolean incomeVisible = true;
    private boolean expenseVisible = true;
    private boolean accountVisible = true;
    private boolean hiddenVisible = true;
    private transient List<ExpandingAccountTableNode> visibleAccounts;
    private transient Engine engine;
    private transient String[] columnNames;
    private transient Class<?>[] columnTypes;
    private static final Logger logger = Logger.getLogger(ExpandingAccountTableModel.class.getName());
    private CommodityFormat formatter = CommodityFormat.getFullFormat();
    private Preferences p = Preferences.userNodeForPackage(this.getClass());
    private static final String HIDDEN_VISIBLE = "HiddenVisible";
    private static final String EXPENSE_VISIBLE = "ExpenseVisible";
    private static final String INCOME_VISIBLE = "IncomeVisible";
    private static final String ACCOUNT_VISIBLE = "AccountVisible";
    private static final String EXPANSION_STATE = "ExpansionState";
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private MessageBusListener messageListener = new MessageBusListener();

    public ExpandingAccountTableModel() {
        logger.setLevel(Level.ALL);
        Resource rb = Resource.get();
        this.columnNames = new String[]{rb.getString("Column.AccountName"), rb.getString("Column.Entries"), rb.getString("Column.Balance"), rb.getString("Column.ReconciledBalance"), rb.getString("Column.Currency"), rb.getString("Column.Type")};
        this.columnTypes = new Class[]{String.class, String.class, BigDecimal.class, BigDecimal.class, String.class, String.class};
        this.engine = EngineFactory.getEngine("default");
        this.visibleAccounts = new ArrayList<ExpandingAccountTableNode>();
        MessageBus.getInstance().registerListener(this.messageListener, MessageChannel.COMMODITY);
        MessageBus.getInstance().registerListener(this.messageListener, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this.messageListener, MessageChannel.SYSTEM);
        AccountBalanceDisplayManager.addAccountBalanceDisplayModeChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandingAccountTableModel.this.fireTableDataChanged();
            }
        });
        this.loadModel();
        this.restoreExpansionState();
        this.buildVisibleModel();
        this.restorePreferences();
    }

    private void restorePreferences() {
        this.setAccountVisible(this.p.getBoolean(ACCOUNT_VISIBLE, true));
        this.setExpenseVisible(this.p.getBoolean(EXPENSE_VISIBLE, true));
        this.setHiddenVisible(this.p.getBoolean(HIDDEN_VISIBLE, true));
        this.setIncomeVisible(this.p.getBoolean(INCOME_VISIBLE, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExpansionState() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            StringBuilder builder = new StringBuilder();
            ArrayList<ExpandingAccountTableNode> values = new ArrayList<ExpandingAccountTableNode>(this.accounts.values());
            Collections.sort(values);
            for (ExpandingAccountTableNode node : values) {
                builder.append(node.isExpanded() ? (char)'1' : '0');
            }
            String string = builder.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExpansionState() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            String state = this.p.get(EXPANSION_STATE, null);
            if (state != null && state.length() == this.accounts.size()) {
                ArrayList<ExpandingAccountTableNode> values = new ArrayList<ExpandingAccountTableNode>(this.accounts.values());
                Collections.sort(values);
                for (int i = 0; i < state.length(); ++i) {
                    values.get(i).setExpanded(state.charAt(i) == '1');
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildVisibleModel() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            ArrayList<ExpandingAccountTableNode> model = new ArrayList<ExpandingAccountTableNode>();
            for (Account child : this.engine.getRootAccount().getChildren()) {
                this.loadVisibleModel(child, model);
            }
            this.visibleAccounts = model;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void unregister() {
        MessageBus.getInstance().unregisterListener(this.messageListener, MessageChannel.COMMODITY);
        MessageBus.getInstance().unregisterListener(this.messageListener, MessageChannel.ACCOUNT);
        MessageBus.getInstance().unregisterListener(this.messageListener, MessageChannel.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeAdded(Account account) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.accounts.put(account, new ExpandingAccountTableNode(account));
            this.buildVisibleModel();
            this.fireTableDataChanged();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.buildVisibleModel();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExpandingAccountTableModel.this.fireTableDataChanged();
                }
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeRemoved(Account account) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            ExpandingAccountTableNode node = this.getNode(account);
            if (node != null) {
                this.accounts.remove(account);
                this.visibleAccounts.remove(node);
                this.fireTableDataChanged();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccountAt(int rowIndex) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Account account = this.visibleAccounts.get(rowIndex).getAccount();
            return account;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpandingAccountTableNode getNode(Account account) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            ExpandingAccountTableNode expandingAccountTableNode = this.accounts.get(account);
            return expandingAccountTableNode;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccountIndex(Account account) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            int index = -1;
            for (ExpandingAccountTableNode n : this.visibleAccounts) {
                if (!n.getAccount().equals(account)) continue;
                index = this.visibleAccounts.indexOf(n);
                break;
            }
            int n = index;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            int n = this.visibleAccounts.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            if (this.visibleAccounts.get(rowIndex) == null) {
                System.out.println("null node");
            } else if (this.visibleAccounts.get(rowIndex).getAccount() == null) {
                System.out.println("null account");
            }
            Account account = this.visibleAccounts.get(rowIndex).getAccount();
            switch (columnIndex) {
                case 0: {
                    String string = account.getName();
                    return string;
                }
                case 1: {
                    Integer n = account.getTransactionCount();
                    return n;
                }
                case 2: {
                    BigDecimal balance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getTreeBalance());
                    String string = this.formatter.format(balance, account.getCurrencyNode());
                    return string;
                }
                case 3: {
                    BigDecimal reconciledBalance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getReconciledTreeBalance());
                    String string = this.formatter.format(reconciledBalance, account.getCurrencyNode());
                    return string;
                }
                case 4: {
                    String string = account.getCurrencyNode().getSymbol();
                    return string;
                }
                case 5: {
                    String string = account.getAccountType().toString();
                    return string;
                }
            }
            String string = "Error";
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean isAccountVisible() {
        return this.accountVisible;
    }

    private boolean isAccountVisible(Account a) {
        ExpandingAccountTableNode node;
        if (!(a.getParent() == null || a.getParent().getAccountType().equals((Object)AccountType.ROOT) || (node = this.getNode(a.getParent())) != null && node.isExpanded())) {
            return false;
        }
        AccountType type = a.getAccountType();
        return type == AccountType.INCOME && this.incomeVisible ? !a.isVisible() && this.hiddenVisible || a.isVisible() : (type == AccountType.EXPENSE && this.expenseVisible ? !a.isVisible() && this.hiddenVisible || a.isVisible() : type != AccountType.INCOME && type != AccountType.EXPENSE && this.accountVisible && (!a.isVisible() && this.hiddenVisible || a.isVisible()));
    }

    public boolean isExpanded(Account account) {
        return this.getNode(account).isExpanded();
    }

    @Override
    public boolean isExpenseVisible() {
        return this.expenseVisible;
    }

    @Override
    public boolean isHiddenVisible() {
        return this.hiddenVisible;
    }

    @Override
    public boolean isIncomeVisible() {
        return this.incomeVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            for (Account account : this.engine.getAccountList()) {
                this.accounts.put(account, new ExpandingAccountTableNode(account));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVisibleModel(Account account, List<ExpandingAccountTableNode> model) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (this.isAccountVisible(account)) {
                model.add(this.getNode(account));
                if (account.isParent()) {
                    for (Account child : account.getChildren()) {
                        this.loadVisibleModel(child, model);
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public synchronized void setAccountVisible(boolean visible) {
        if (this.accountVisible != visible) {
            this.p.putBoolean(ACCOUNT_VISIBLE, visible);
            this.accountVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setExpenseVisible(boolean visible) {
        if (this.expenseVisible != visible) {
            this.p.putBoolean(EXPENSE_VISIBLE, visible);
            this.expenseVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setHiddenVisible(boolean visible) {
        if (this.hiddenVisible != visible) {
            this.p.putBoolean(HIDDEN_VISIBLE, visible);
            this.hiddenVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setIncomeVisible(boolean visible) {
        if (this.incomeVisible != visible) {
            this.p.putBoolean(INCOME_VISIBLE, visible);
            this.incomeVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleExpansion(Account account) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (account.isParent()) {
                ExpandingAccountTableNode node;
                node.setExpanded(!(node = this.getNode(account)).isExpanded());
                this.fireNodeChanged();
                this.p.put(EXPANSION_STATE, this.getExpansionState());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private class MessageBusListener
    implements MessageListener {
        private MessageBusListener() {
        }

        @Override
        public void messagePosted(final Message event) {
            if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
                ExpandingAccountTableModel.this.unregister();
                return;
            }
            if (EngineFactory.getEngine("default") == null) {
                return;
            }
            final Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case ACCOUNT_ADD: {
                            ExpandingAccountTableModel.this.fireNodeAdded(a);
                            break;
                        }
                        case ACCOUNT_REMOVE: {
                            ExpandingAccountTableModel.this.fireNodeRemoved(a);
                            break;
                        }
                        case ACCOUNT_MODIFY: 
                        case ACCOUNT_VISABILITY_CHANGE: 
                        case COMMODITY_HISTORY_ADD: 
                        case COMMODITY_HISTORY_REMOVE: {
                            ExpandingAccountTableModel.this.fireNodeChanged();
                            break;
                        }
                        case FILE_LOAD_SUCCESS: 
                        case FILE_NEW_SUCCESS: {
                            logger.warning("Should not have received a load and new file notification");
                            break;
                        }
                    }
                }
            });
        }
    }
}

