/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.UIApplication;
import jgnash.ui.components.CurrencyComboBox;
import jgnash.util.Resource;

public class StaticUIMethods {
    protected static void setDefaultCurrency(final JFrame frame) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                CurrencyComboBox combo = new CurrencyComboBox();
                Object[] options = new Object[]{rb.getString("Button.Ok"), rb.getString("Button.Cancel")};
                int result = JOptionPane.showOptionDialog(frame, combo, rb.getString("Title.SelDefCurr"), 0, -1, null, options, options[1]);
                if (result == 0) {
                    Engine engine = EngineFactory.getEngine("default");
                    engine.setDefaultCurrency((CurrencyNode)combo.getSelectedNode());
                    JOptionPane.showMessageDialog(frame, rb.getString("Message.CurrChange") + " " + engine.getDefaultCurrency().getSymbol());
                }
            }
        });
    }

    protected static void setDefaultLocale(final JFrame frame) {
        final Resource rb = Resource.get();
        SwingWorker<LocaleObject[], Void> worker = new SwingWorker<LocaleObject[], Void>(){
            private Object[] options;

            @Override
            public LocaleObject[] doInBackground() {
                this.options = new Object[]{rb.getString("Button.Ok"), rb.getString("Button.Cancel")};
                Locale[] tList = Locale.getAvailableLocales();
                Object[] list = new LocaleObject[tList.length];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = new LocaleObject(tList[i]);
                }
                Arrays.sort(list);
                return list;
            }

            @Override
            public void done() {
                try {
                    JComboBox<Object> combo = new JComboBox<Object>((Object[])this.get());
                    combo.setSelectedItem(new LocaleObject(Resource.getLocale()));
                    int result = JOptionPane.showOptionDialog(frame, combo, rb.getString("Title.SelDefLocale"), 0, -1, null, this.options, this.options[1]);
                    if (result == 0) {
                        LocaleObject o = (LocaleObject)combo.getSelectedItem();
                        Resource.setLocale(o.locale);
                        JOptionPane.showMessageDialog(frame, o.toString() + "\n" + rb.getString("Message.RestartLocale"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public static void displayError(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                Frame frame = UIApplication.getFrame();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Window window = keyboardFocusManager.getActiveWindow();
                if (window != null && window instanceof Frame) {
                    frame = (Frame)window;
                }
                JOptionPane.showMessageDialog(frame, message, rb.getString("Title.Error"), 0);
            }
        });
    }

    private StaticUIMethods() {
    }

    private static class LocaleObject
    implements Comparable<LocaleObject> {
        Locale locale;
        private String display;

        protected LocaleObject(Locale locale) {
            this.locale = locale;
            this.display = locale.getDisplayName() + " - " + locale.toString() + "  [" + locale.getDisplayName(locale) + "]";
        }

        public final String toString() {
            return this.display;
        }

        @Override
        public int compareTo(LocaleObject o) {
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            assert (obj instanceof LocaleObject);
            return this.equals((LocaleObject)obj);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.locale != null ? this.locale.hashCode() : 0);
            hash = 47 * hash + (this.display != null ? this.display.hashCode() : 0);
            return hash;
        }

        public boolean equals(LocaleObject obj) {
            return obj.locale.equals(this.locale);
        }
    }
}

