/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net;

import java.awt.GridLayout;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class NetworkAuthenticator
extends Authenticator {
    public static final String NODEHTTP = "/jgnash/http";
    private static final String HTTPUSER = "httpuser";
    private static final String HTTPPASS = "httppass";
    public static final String USEPROXY = "useproxy";
    private static final String USEAUTH = "useauth";
    public static final String PROXYHOST = "proxyhost";
    public static final String PROXYPORT = "proxyport";
    private Preferences auth = Preferences.userRoot().node("/jgnash/http");

    public static void setName(String name) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.put(HTTPUSER, name);
    }

    public static String getName() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.get(HTTPUSER, "user");
    }

    public static void setHost(String host) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.put(PROXYHOST, host);
    }

    public static String getHost() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.get(PROXYHOST, "localhost");
    }

    public static void setPort(int port) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.putInt(PROXYPORT, port);
    }

    public static int getPort() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.getInt(PROXYPORT, 8080);
    }

    public static void setPassword(String password) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.put(HTTPPASS, password);
    }

    public static String getPassword() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.get(HTTPPASS, "");
    }

    public static void setUseAuthentication(boolean use) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.putBoolean(USEAUTH, use);
    }

    public static void setUseProxy(boolean use) {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        pref.putBoolean(USEPROXY, use);
    }

    public static boolean isProxyUsed() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.getBoolean(USEPROXY, false);
    }

    public static boolean isAuthenticationUsed() {
        Preferences pref = Preferences.userRoot().node(NODEHTTP);
        return pref.getBoolean(USEAUTH, false);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String user;
        char[] pass = null;
        String _pass = this.auth.get(HTTPPASS, null);
        if (_pass != null && _pass.length() > 0) {
            pass = _pass.toCharArray();
        }
        if ((user = this.auth.get(HTTPUSER, null)) != null && user.length() <= 0) {
            user = null;
        }
        if (user == null || pass == null) {
            JTextField username = new JTextField();
            JPasswordField password = new JPasswordField();
            JPanel panel = new JPanel(new GridLayout(2, 2));
            panel.add(new JLabel("User Name"));
            panel.add(username);
            panel.add(new JLabel("Password"));
            panel.add(password);
            int option = JOptionPane.showConfirmDialog(null, new Object[]{"Site: " + this.getRequestingHost(), "Realm: " + this.getRequestingPrompt(), panel}, "Enter Network Password", 2, -1);
            if (option == 0) {
                user = username.getText();
                pass = password.getPassword();
            } else {
                return null;
            }
        }
        return new PasswordAuthentication(user, pass);
    }
}

