/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xml;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jgnash.engine.StoredObject;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.dao.ConfigDAO;
import jgnash.engine.dao.EngineDAO;
import jgnash.engine.dao.RecurringDAO;
import jgnash.engine.dao.TransactionDAO;
import jgnash.engine.dao.TrashDAO;
import jgnash.engine.xml.AbstractXMLDAO;
import jgnash.engine.xml.XMLAccountDAO;
import jgnash.engine.xml.XMLCommodityDAO;
import jgnash.engine.xml.XMLConfigDAO;
import jgnash.engine.xml.XMLContainer;
import jgnash.engine.xml.XMLRecurringDAO;
import jgnash.engine.xml.XMLTransactionDAO;
import jgnash.engine.xml.XMLTrashDAO;

public class XMLEngineDAO
extends AbstractXMLDAO
implements EngineDAO {
    private AccountDAO accountDAO;
    private CommodityDAO commodityDAO;
    private ConfigDAO configDAO;
    private RecurringDAO recurringDAO;
    private TransactionDAO transactionDAO;
    private TrashDAO trashDAO;
    private ScheduledExecutorService commitExecutor;
    ScheduledFuture<?> future;
    private Timer commitTimer = new Timer();

    protected XMLEngineDAO(XMLContainer container) {
        super(container);
        this.commitExecutor = Executors.newSingleThreadScheduledExecutor();
        this.commitTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (XMLEngineDAO.this.future != null && !XMLEngineDAO.this.future.isDone() || XMLEngineDAO.this.commitExecutor == null) {
                    return;
                }
                XMLEngineDAO.this.future = XMLEngineDAO.this.commitExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractXMLDAO.commitCount.get() > 0) {
                            Logger.getLogger(XMLEngineDAO.class.getName()).info("Commiting file");
                            XMLEngineDAO.this.commitAndReset();
                        }
                    }
                }, 0L, TimeUnit.SECONDS);
            }
        }, 30000L, 30000L);
    }

    @Override
    public synchronized void shutdown() {
        this.commitTimer.cancel();
        this.commitExecutor.shutdown();
        this.commitExecutor = null;
    }

    @Override
    public synchronized AccountDAO getAccountDAO() {
        if (this.accountDAO == null) {
            this.accountDAO = new XMLAccountDAO(this.container);
        }
        return this.accountDAO;
    }

    @Override
    public synchronized CommodityDAO getCommodityDAO() {
        if (this.commodityDAO == null) {
            this.commodityDAO = new XMLCommodityDAO(this.container);
        }
        return this.commodityDAO;
    }

    @Override
    public synchronized ConfigDAO getConfigDAO() {
        if (this.configDAO == null) {
            this.configDAO = new XMLConfigDAO(this.container);
        }
        return this.configDAO;
    }

    @Override
    public synchronized RecurringDAO getRecurringDAO() {
        if (this.recurringDAO == null) {
            this.recurringDAO = new XMLRecurringDAO(this.container);
        }
        return this.recurringDAO;
    }

    @Override
    public synchronized TransactionDAO getTransactionDAO() {
        if (this.transactionDAO == null) {
            this.transactionDAO = new XMLTransactionDAO(this.container);
        }
        return this.transactionDAO;
    }

    @Override
    public synchronized TrashDAO getTrashDAO() {
        if (this.trashDAO == null) {
            this.trashDAO = new XMLTrashDAO(this.container);
        }
        return this.trashDAO;
    }

    @Override
    public StoredObject getObjectByUuid(String uuid) {
        return this.container.get(uuid);
    }

    @Override
    public List<StoredObject> getStoredObjects() {
        return this.container.asList();
    }
}

