/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.Configuration;
import com.db4o.messaging.MessageRecipient;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.EngineFactory;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.TrashObject;
import jgnash.engine.db4o.Db4oDataStore;
import jgnash.message.LocalServerListener;
import jgnash.message.MessageBusRemoteServer;
import jgnash.message.StopServer;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

public class Db4oNetworkServer
implements MessageRecipient {
    private volatile boolean stop = false;
    private ScheduledExecutorService backupExecutor;
    private static final int BACKUP_PERIOD = 2;
    private volatile boolean dirty = false;

    public synchronized void runServer(final String fileName, int port, String user, String password) {
        this.stop = false;
        final ObjectServer server = Db4oNetworkServer.createObjectServer(fileName, port, user, password);
        if (server != null) {
            server.ext().configure().clientServer().setMessageRecipient((MessageRecipient)this);
            Thread.currentThread().setName(this.getClass().getName());
            Thread.currentThread().setPriority(1);
            MessageBusRemoteServer messageServer = new MessageBusRemoteServer(port + 1);
            messageServer.startServer();
            this.backupExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultDaemonThreadFactory());
            this.backupExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (Db4oNetworkServer.this.dirty) {
                        Db4oNetworkServer.this.exportXML(server, fileName);
                        EngineFactory.removeOldCompressedXML(fileName);
                        Db4oNetworkServer.this.dirty = false;
                    }
                }
            }, 2L, 2L, TimeUnit.HOURS);
            messageServer.addLocalListener(new LocalServerListener(){

                @Override
                public void messagePosted(String event) {
                    Db4oNetworkServer.this.dirty = true;
                }
            });
            try {
                if (!this.stop) {
                    this.wait(Long.MAX_VALUE);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.backupExecutor.shutdown();
            this.exportXML(server, fileName);
            EngineFactory.removeOldCompressedXML(fileName);
            messageServer.stopServer();
            server.close();
        }
    }

    private synchronized void close() {
        this.stop = true;
        this.notify();
    }

    private static ObjectServer createObjectServer(String fileName, int port, String user, String password) {
        ObjectServer objectServer = null;
        try {
            if (!FileUtils.isFileLocked(fileName)) {
                boolean result;
                File parent;
                Configuration config = Db4oDataStore.createConfig();
                File file = new File(fileName);
                if (!(file.exists() || (parent = file.getParentFile()) == null || parent.exists() || (result = parent.mkdirs()))) {
                    throw new RuntimeException("Could not create directory for file: " + parent.getAbsolutePath());
                }
                objectServer = Db4o.openServer((Configuration)config, (String)fileName, (int)port);
                objectServer.grantAccess(user, password);
            } else {
                Logger.getLogger(Db4oNetworkServer.class.getName()).severe(Resource.get().getString("Message.FileIsLocked"));
            }
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(Db4oNetworkServer.class.getName()).log(Level.SEVERE, e.toString(), e);
        }
        return objectServer;
    }

    public void processMessage(ObjectContainer container, Object message) {
        if (message instanceof StopServer) {
            this.close();
        }
    }

    private void exportXML(ObjectServer server, String fileName) {
        ObjectContainer container = server.ext().objectContainer();
        ArrayList<StoredObject> list = new ArrayList<StoredObject>((Collection<StoredObject>)container.query(StoredObject.class));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StoredObject o = (StoredObject)i.next();
            if (!(o instanceof TrashObject) && !o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(list, new StoredObjectComparator());
        EngineFactory.exportCompressedXML(fileName, list);
    }
}

