/*
 * Decompiled with CFR 0.152.
 */
package net.bzzt.swift.mt940.parser;

import java.io.IOException;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.bzzt.swift.mt940.Mt940Entry;
import net.bzzt.swift.mt940.Mt940File;
import net.bzzt.swift.mt940.Mt940Record;

public class Mt940Parser {
    public Mt940File parse(LineNumberReader reader) throws IOException, ParseException {
        Mt940File retval = new Mt940File();
        ArrayList<String> recordLines = new ArrayList<String>();
        String currentLine = reader.readLine();
        while (currentLine != null) {
            if (currentLine.startsWith("-")) {
                List<String> mergedLines = this.mergeLines(recordLines);
                retval.getRecords().add(this.parseRecord(mergedLines));
                recordLines = new ArrayList();
            } else {
                recordLines.add(currentLine);
            }
            currentLine = reader.readLine();
        }
        return retval;
    }

    private List<String> mergeLines(List<String> recordLines) {
        ArrayList<String> retval = new ArrayList<String>();
        String currentString = null;
        boolean inMessage = false;
        for (String string : recordLines) {
            if (inMessage) {
                if (string.startsWith(":")) {
                    retval.add(currentString);
                    currentString = "";
                }
                currentString = currentString + string;
                continue;
            }
            if (string.startsWith(":")) {
                inMessage = true;
                currentString = string;
                continue;
            }
            retval.add(string);
        }
        return retval;
    }

    private Mt940Record parseRecord(List<String> recordLines) throws ParseException {
        Mt940Record retval = new Mt940Record();
        Mt940Entry currentEntry = null;
        for (String line : recordLines) {
            if (line.startsWith(":61:")) {
                currentEntry = new Mt940Entry();
                line = line.substring(4);
                line = this.parseDatumJJMMTT(currentEntry, line);
                line = line.substring(4);
                line = this.parseSollHabenKennung(currentEntry, line);
                line = this.parseBetrag(currentEntry, line);
            }
            if (!line.startsWith(":86:")) continue;
            if (currentEntry == null) {
                currentEntry = new Mt940Entry();
            }
            currentEntry.setMehrzweckfeld(line.substring(4));
            retval.getEntries().add(currentEntry);
            currentEntry = null;
        }
        return retval;
    }

    private String parseBetrag(Mt940Entry currentEntry, String line) {
        int endIndex = line.indexOf(78);
        if (endIndex < 0) {
            endIndex = line.indexOf(70);
        }
        String betrag = line.substring(0, endIndex);
        betrag = betrag.replaceAll(",", ".");
        currentEntry.setBetrag(new BigDecimal(betrag));
        return line.substring(endIndex);
    }

    private String parseSollHabenKennung(Mt940Entry currentEntry, String string) {
        String s = string;
        if (string.startsWith("D")) {
            currentEntry.setSollHabenKennung(Mt940Entry.SollHabenKennung.DEBIT);
            s = string.substring(1);
        } else if (string.startsWith("C")) {
            currentEntry.setSollHabenKennung(Mt940Entry.SollHabenKennung.CREDIT);
            s = string.substring(1);
        } else {
            throw new UnsupportedOperationException("soll-haben-kennung " + s + " not yet supported");
        }
        return s;
    }

    private String parseDatumJJMMTT(Mt940Entry currentEntry, String string) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
        String date = string.substring(0, 6);
        currentEntry.setValutaDatum(format.parse(date));
        return string.substring(6);
    }
}

