/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.StoredFieldImpl;
import com.db4o.internal.Transaction;

public class StoredClassImpl
implements StoredClass {
    private final Transaction _transaction;
    private final ClassMetadata _classMetadata;

    public StoredClassImpl(Transaction transaction, ClassMetadata classMetadata) {
        if (classMetadata == null) {
            throw new IllegalArgumentException();
        }
        this._transaction = transaction;
        this._classMetadata = classMetadata;
    }

    public long[] getIDs() {
        return this._classMetadata.getIDs(this._transaction);
    }

    public String getName() {
        return this._classMetadata.getName();
    }

    public StoredClass getParentStoredClass() {
        ClassMetadata classMetadata = this._classMetadata.getAncestor();
        if (classMetadata == null) {
            return null;
        }
        return new StoredClassImpl(this._transaction, classMetadata);
    }

    public StoredField[] getStoredFields() {
        StoredField[] storedFieldArray = this._classMetadata.getStoredFields();
        StoredField[] storedFieldArray2 = new StoredField[storedFieldArray.length];
        for (int i = 0; i < storedFieldArray.length; ++i) {
            storedFieldArray2[i] = new StoredFieldImpl(this._transaction, (FieldMetadata)storedFieldArray[i]);
        }
        return storedFieldArray2;
    }

    public boolean hasClassIndex() {
        return this._classMetadata.hasClassIndex();
    }

    public void rename(String string) {
        this._classMetadata.rename(string);
    }

    public StoredField storedField(String string, Object object) {
        FieldMetadata fieldMetadata = (FieldMetadata)this._classMetadata.storedField(string, object);
        if (fieldMetadata == null) {
            return null;
        }
        return new StoredFieldImpl(this._transaction, fieldMetadata);
    }

    public int hashCode() {
        return this._classMetadata.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this._classMetadata.equals(((StoredClassImpl)object)._classMetadata);
    }
}

