/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.fill.JRFillCategorySeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.components.spiderchart.SpiderChartCompiler;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class FillSpiderDataset
extends JRFillElementDataset
implements SpiderDataset {
    protected JRFillCategorySeries[] categorySeries = null;
    private DefaultCategoryDataset dataset = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public FillSpiderDataset(SpiderDataset spiderDataset, JRFillObjectFactory factory) {
        super(spiderDataset, factory);
        JRCategorySeries[] srcCategorySeries = spiderDataset.getSeries();
        if (srcCategorySeries != null && srcCategorySeries.length > 0) {
            this.categorySeries = new JRFillCategorySeries[srcCategorySeries.length];
            for (int i = 0; i < srcCategorySeries.length; ++i) {
                this.categorySeries[i] = (JRFillCategorySeries)factory.getCategorySeries(srcCategorySeries[i]);
            }
        }
    }

    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    protected void customInitialize() {
        this.dataset = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            if (this.dataset == null) {
                this.dataset = new DefaultCategoryDataset();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.categorySeries.length; ++i) {
                JRFillCategorySeries crtCategorySeries = this.categorySeries[i];
                Comparable seriesName = crtCategorySeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException("Category series name is null.");
                }
                this.dataset.addValue(crtCategorySeries.getValue(), crtCategorySeries.getSeries(), crtCategorySeries.getCategory());
                if (crtCategorySeries.getLabelExpression() != null) {
                    HashMap<Comparable, String> seriesLabels = (HashMap<Comparable, String>)this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<Comparable, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(crtCategorySeries.getCategory(), crtCategorySeries.getLabel());
                }
                if (!crtCategorySeries.hasItemHyperlinks()) continue;
                HashMap<Comparable, JRPrintHyperlink> seriesLinks = (HashMap<Comparable, JRPrintHyperlink>)this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<Comparable, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                seriesLinks.put(crtCategorySeries.getCategory(), crtCategorySeries.getPrintItemHyperlink());
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public Object getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        SpiderChartCompiler.collectExpressions(this, collector);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length && !foundLinks; ++i) {
                JRFillCategorySeries serie = this.categorySeries[i];
                foundLinks = serie.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    public void finishDataset() {
        this.increment();
    }
}

