/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jgnash.util.SearchUtils;

public final class FileUtils {
    private static final String FILEEXTREGEX = "(?<=\\.).*$";

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileLocked(String fileName) throws FileNotFoundException {
        boolean result = true;
        RandomAccessFile raf = new RandomAccessFile(new File(fileName), "rw");
        FileChannel channel = null;
        try {
            channel = raf.getChannel();
            FileLock lock = channel.tryLock();
            if (lock != null) {
                lock.release();
                result = false;
            }
        }
        catch (IOException e) {
            result = true;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
            try {
                raf.close();
            }
            catch (IOException e) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    public static String stripFileExtension(String fileName) {
        return fileName.split("\\.")[0];
    }

    public static boolean fileHasExtension(String fileName) {
        return !FileUtils.stripFileExtension(fileName).equals(fileName);
    }

    public static String getFileExtension(String fileName) {
        String result = "";
        Pattern pattern = Pattern.compile(FILEEXTREGEX);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            result = matcher.group();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dst) throws FileNotFoundException {
        if (src == null || dst == null || src.equals(dst)) {
            return false;
        }
        boolean result = false;
        if (src.exists()) {
            if (dst.exists() && !dst.canWrite()) {
                return false;
            }
            FileInputStream srcStream = new FileInputStream(src);
            FileOutputStream dstStream = new FileOutputStream(dst);
            FileChannel srcChannel = srcStream.getChannel();
            FileChannel dstChannel = dstStream.getChannel();
            FileLock dstLock = null;
            FileLock srcLock = null;
            try {
                srcLock = srcChannel.tryLock(0L, Long.MAX_VALUE, true);
                dstLock = dstChannel.tryLock();
                if (srcLock != null && dstLock != null) {
                    int maxCount = 67076096;
                    long size = srcChannel.size();
                    for (long position = 0L; position < size; position += srcChannel.transferTo(position, maxCount, dstChannel)) {
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (srcChannel != null) {
                    try {
                        if (srcLock != null) {
                            srcLock.release();
                        }
                        srcChannel.close();
                        srcStream.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (dstChannel != null) {
                    try {
                        if (dstLock != null) {
                            dstLock.release();
                        }
                        dstChannel.close();
                        dstStream.close();
                        result = true;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(File source, File destination) {
        byte[] ioBuffer = new byte[8192];
        FileInputStream in = null;
        FileLock fisLock = null;
        try {
            FileOutputStream fos = new FileOutputStream(destination);
            FileLock fosLock = fos.getChannel().tryLock();
            in = new FileInputStream(source);
            fisLock = in.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (fosLock != null && fisLock != null) {
                int length;
                ZipOutputStream zipOut = new ZipOutputStream(fos);
                zipOut.setLevel(9);
                zipOut.putNextEntry(new ZipEntry(source.getName()));
                while ((length = in.read(ioBuffer)) > 0) {
                    zipOut.write(ioBuffer, 0, length);
                }
                zipOut.closeEntry();
                fosLock.release();
                zipOut.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    if (fisLock != null) {
                        fisLock.release();
                    }
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
    }

    public static List<File> getDirectoryListing(File directory, String pattern) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (directory != null && directory.isDirectory()) {
            final Pattern p = SearchUtils.createSearchPattern(pattern, false);
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return p.matcher(name).matches();
                }
            });
            fileList.addAll(Arrays.asList(files));
            Collections.sort(fileList);
        }
        return fileList;
    }
}

