/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.Comparators;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

abstract class AbstractCrosstabReport
extends DynamicJasperReport {
    private DatePanel startDateField;
    private DatePanel endDateField;
    private JButton refreshButton;
    private JCheckBox hideZeroBalanceAccounts;
    private final String RES_YEAR;
    private final String RES_QUARTER;
    private final String RES_MONTH;
    private JComboBox resolutionList;
    private JCheckBox showLongNamesCheckBox;
    private final ArrayList<Date> startDates;
    private final ArrayList<Date> endDates;
    private final ArrayList<String> dateLabels;
    private static final String HIDE_ZERO_BALANCE = "hideZeroBalance";
    private static final String MONTHS = "months";
    private static final String USE_LONG_NAMES = "useLongNames";

    public AbstractCrosstabReport() {
        this.RES_YEAR = this.rb.getString("Word.Yearly");
        this.RES_QUARTER = this.rb.getString("Word.Quarterly");
        this.RES_MONTH = this.rb.getString("Word.Monthly");
        this.startDates = new ArrayList();
        this.endDates = new ArrayList();
        this.dateLabels = new ArrayList();
        Preferences p = this.getPreferences();
        Date startDate = new Date();
        startDate = DateUtils.previousYear(startDate);
        this.startDateField = new DatePanel();
        this.endDateField = new DatePanel();
        this.startDateField.setDate(startDate);
        this.hideZeroBalanceAccounts = new JCheckBox(Resource.get().getString("Button.HideZeroBalance"));
        this.hideZeroBalanceAccounts.setSelected(p.getBoolean(HIDE_ZERO_BALANCE, true));
        this.showLongNamesCheckBox = new JCheckBox(this.rb.getString("Button.UseLongNames"));
        this.showLongNamesCheckBox.setSelected(p.getBoolean(USE_LONG_NAMES, false));
        this.resolutionList = new JComboBox<String>(new String[]{this.RES_YEAR, this.RES_QUARTER, this.RES_MONTH});
        this.resolutionList.setSelectedIndex(1);
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractCrosstabReport.this.refreshReport();
            }
        });
    }

    @Override
    public String getSubTitle() {
        MessageFormat format = new MessageFormat(this.rb.getString("Pattern.DateRange"));
        Object[] args = new Object[]{this.startDates.get(0), this.endDates.get(this.endDates.size() - 1)};
        return format.format(args);
    }

    @Override
    protected void refreshReport() {
        Preferences p = this.getPreferences();
        p.putBoolean(HIDE_ZERO_BALANCE, this.hideZeroBalanceAccounts.isSelected());
        p.putBoolean(USE_LONG_NAMES, this.showLongNamesCheckBox.isSelected());
        p.putInt(MONTHS, DateUtils.lastDaysOfMonth(this.startDateField.getDate(), this.endDateField.getDate()).size());
        super.refreshReport();
    }

    protected abstract List<AccountGroup> getAccountGroups();

    private void updateResolution() {
        this.startDates.clear();
        this.endDates.clear();
        this.dateLabels.clear();
        String currentResolution = (String)this.resolutionList.getSelectedItem();
        Calendar cal = Calendar.getInstance();
        Date globalStart = this.startDateField.getDate();
        Date globalEnd = this.endDateField.getDate();
        Calendar globalStartCal = Calendar.getInstance();
        globalStartCal.setTime(globalStart);
        Calendar globalEndCal = Calendar.getInstance();
        globalEndCal.setTime(globalEnd);
        Date start = new Date(globalStart.getTime());
        Date end = new Date(globalStart.getTime());
        if (this.RES_YEAR.equals(currentResolution)) {
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.lastDayOfYear(start);
                this.endDates.add(end);
                cal.setTime(start);
                this.dateLabels.add("    " + cal.get(1));
                start = DateUtils.nextDay(end);
            }
        } else if (this.RES_QUARTER.equals(currentResolution)) {
            int i = DateUtils.getQuarterNumber(start) - 1;
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.lastDayOfQuarter(start);
                this.endDates.add(end);
                cal.setTime(start);
                this.dateLabels.add(" " + cal.get(1) + "-Q" + (1 + i++ % 4));
                start = DateUtils.nextDay(end);
            }
        } else if (this.RES_MONTH.equals(currentResolution)) {
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.lastDayOfMonth(start);
                this.endDates.add(end);
                cal.setTime(start);
                int month = cal.get(2);
                this.dateLabels.add(" " + cal.get(1) + (month < 9 ? "/0" + (month + 1) : "/" + (month + 1)));
                start = DateUtils.nextDay(end);
            }
        }
        assert (this.startDates.size() == this.endDates.size() && this.startDates.size() == this.dateLabels.size());
        if (this.endDates.get(this.startDates.size() - 1).compareTo(globalEnd) > 0) {
            this.endDates.set(this.endDates.size() - 1, globalEnd);
        }
    }

    private ReportModel createTableModel() {
        this.logger.info(this.rb.getString("Message.CollectingReportData"));
        CurrencyNode baseCurrency = EngineFactory.getEngine("default").getDefaultCurrency();
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (AccountGroup group : this.getAccountGroups()) {
            List<Account> list = this.getAccountList(AccountGroup.getAccountTypes(group));
            if (!this.showLongNamesCheckBox.isSelected()) {
                Collections.sort(list, Comparators.getAccountByName());
            }
            accounts.addAll(list);
        }
        this.updateResolution();
        if (this.hideZeroBalanceAccounts.isSelected()) {
            Iterator i = accounts.iterator();
            while (i.hasNext()) {
                Account account = (Account)i.next();
                boolean remove = true;
                for (int j = 0; j < this.endDates.size(); ++j) {
                    if (account.getBalance(this.startDates.get(j), this.endDates.get(j)).compareTo(BigDecimal.ZERO) == 0) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                i.remove();
            }
        }
        return new ReportModel(accounts, baseCurrency);
    }

    private List<Account> getAccountList(Set<AccountType> types) {
        Engine engine = EngineFactory.getEngine("default");
        List<Account> accounts = engine.getAccountList();
        Iterator<Account> i = accounts.iterator();
        block0: while (i.hasNext()) {
            Account a = i.next();
            if (a.getTransactionCount() == 0) {
                i.remove();
                continue;
            }
            for (AccountType t : types) {
                if (!a.getAccountType().equals((Object)t)) continue;
                continue block0;
            }
            i.remove();
        }
        return accounts;
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        ReportModel model = this.createTableModel();
        return this.createJasperPrint(model, formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, 4dlu, max(p;45dlu), 8dlu, p, 4dlu, max(p;45dlu), 8dlu, p, 4dlu, p, 8dlu, p, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        builder.append(this.rb.getString("Label.Resolution"), (Component)this.resolutionList);
        builder.append((Component)this.refreshButton);
        builder.nextLine();
        builder.append((Component)this.showLongNamesCheckBox, 6);
        builder.append((Component)this.hideZeroBalanceAccounts, 6);
        return builder.getPanel();
    }

    private class ReportModel
    extends AbstractReportTableModel {
        private CurrencyNode baseCurrency;
        private List<Account> accountList = Collections.emptyList();
        private static final long serialVersionUID = -2526030825754030630L;

        protected ReportModel(List<Account> accountList, CurrencyNode currency) {
            this.accountList = accountList;
            this.baseCurrency = currency;
        }

        @Override
        public CurrencyNode getCurrency() {
            return this.baseCurrency;
        }

        @Override
        public int getRowCount() {
            return this.accountList.size();
        }

        @Override
        public int getColumnCount() {
            return AbstractCrosstabReport.this.startDates.size() + 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return AbstractCrosstabReport.this.rb.getString("Column.Account");
            }
            if (columnIndex == this.getColumnCount() - 2) {
                return "";
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return "Type";
            }
            return (String)AbstractCrosstabReport.this.dateLabels.get(columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return String.class;
            }
            return BigDecimal.class;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnStyle.STRING;
            }
            if (columnIndex == this.getColumnCount() - 2) {
                return ColumnStyle.CROSSTAB_TOTAL;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return ColumnStyle.GROUP;
            }
            return ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnHeaderStyle.LEFT;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return ColumnHeaderStyle.CENTER;
            }
            return ColumnHeaderStyle.RIGHT;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Account a = this.accountList.get(rowIndex);
            if (columnIndex == 0) {
                if (AbstractCrosstabReport.this.showLongNamesCheckBox.isSelected()) {
                    return a.getPathName();
                }
                return a.getName();
            }
            if (columnIndex == this.getColumnCount() - 2) {
                return this.getCrossTabAmount(rowIndex);
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return a.getAccountType().getAccountGroup().toString();
            }
            if (columnIndex > 0 && columnIndex <= AbstractCrosstabReport.this.startDates.size()) {
                return a.getBalance((Date)AbstractCrosstabReport.this.startDates.get(columnIndex - 1), (Date)AbstractCrosstabReport.this.endDates.get(columnIndex - 1), this.getCurrency()).negate();
            }
            return null;
        }

        private BigDecimal getCrossTabAmount(int rowIndex) {
            Account a = this.accountList.get(rowIndex);
            Date startDate = (Date)AbstractCrosstabReport.this.startDates.get(0);
            Date endDate = (Date)AbstractCrosstabReport.this.endDates.get(AbstractCrosstabReport.this.endDates.size() - 1);
            return a.getBalance(startDate, endDate, this.getCurrency()).negate();
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return columnIndex > 0 && columnIndex < this.getColumnCount() - 1;
        }
    }
}

