/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.prefs.Preferences;
import javax.print.PrintService;
import jgnash.ui.report.jasper.DynamicJasperReport;

public class ReportPrintFactory {
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String ORIENTATION = "orientation";
    private static final String IMAGEABLE_HEIGHT = "imageableHeight";
    private static final String IMAGEABLE_WIDTH = "imageableWidth";
    private static final String IMAGEABLE_X = "imageableX";
    private static final String IMAGEABLE_Y = "imageableY";

    private ReportPrintFactory() {
    }

    private static PageFormat getDefaultPage() {
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length == 0) {
            return new PageFormat();
        }
        return PrinterJob.getPrinterJob().defaultPage();
    }

    public static void savePageFormat(DynamicJasperReport report, PageFormat format) {
        Preferences p = report.getPreferences();
        p.putInt(ORIENTATION, format.getOrientation());
        Paper paper = format.getPaper();
        p.putDouble(HEIGHT, paper.getHeight());
        p.putDouble(WIDTH, paper.getWidth());
        p.putDouble(IMAGEABLE_HEIGHT, paper.getImageableHeight());
        p.putDouble(IMAGEABLE_WIDTH, paper.getImageableWidth());
        p.putDouble(IMAGEABLE_X, paper.getImageableX());
        p.putDouble(IMAGEABLE_Y, paper.getImageableY());
    }

    public static PageFormat getPageFormat(DynamicJasperReport report) {
        Preferences p = report.getPreferences();
        double height = p.getDouble(HEIGHT, 0.0);
        double width = p.getDouble(WIDTH, 0.0);
        int orientation = p.getInt(ORIENTATION, 0);
        double imageableHeight = p.getDouble(IMAGEABLE_HEIGHT, 0.0);
        double imageableWidth = p.getDouble(IMAGEABLE_WIDTH, 0.0);
        double imageableX = p.getDouble(IMAGEABLE_X, 0.0);
        double imageableY = p.getDouble(IMAGEABLE_Y, 0.0);
        if (height == 0.0 || width == 0.0 || imageableHeight == 0.0 || imageableWidth == 0.0) {
            return ReportPrintFactory.getDefaultPage();
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.defaultPage();
        pf.setOrientation(orientation);
        Paper paper = pf.getPaper();
        paper.setSize(width, height);
        paper.setImageableArea(imageableX, imageableY, imageableWidth, imageableHeight);
        pf.setPaper(paper);
        return pf;
    }
}

