/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import jgnash.ui.UIApplication;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.components.JGJXMonthView;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;

public class DateSelectDialog
extends GenericCloseDialog {
    JXMonthView view;

    public static Date showDialog(Date date) {
        return DateSelectDialog.showDialog(UIApplication.getFrame(), date);
    }

    public static Date showDialog(Window parent, Date date) {
        DateSelectDialog d = new DateSelectDialog(parent, date);
        d.pack();
        d.setMaximumSize(d.getSize());
        d.setMinimumSize(d.getSize());
        d.setResizable(false);
        DialogUtils.addBoundsListener(d);
        d.setVisible(true);
        Date selectedDate = d.getDate();
        if (selectedDate != null) {
            return selectedDate;
        }
        return date;
    }

    private DateSelectDialog(Window parent, Date date) {
        super(parent, new JPanel(), Resource.get().getString("Title.SelDate"));
        this.createPanel((JPanel)this.getComponent());
        this.setDate(date);
    }

    void setDate(Date date) {
        this.view.setFirstDisplayedDay(date);
        this.view.setSelectionDate(date);
    }

    Date getDate() {
        return this.view.getFirstSelectionDate();
    }

    private void createPanel(JPanel panel) {
        this.view = new JGJXMonthView();
        this.view.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        this.view.setTraversable(true);
        this.view.setShowingLeadingDays(true);
        this.view.setShowingTrailingDays(true);
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("dateAccepted")) {
                    DateSelectDialog.this.closeWindow();
                }
            }
        });
        Resource rb = Resource.get();
        JButton today = new JButton(rb.getString("Button.Today"));
        today.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateSelectDialog.this.view.setFirstDisplayedDay(new Date());
                DateSelectDialog.this.view.setSelectionDate(new Date());
            }
        });
        FormLayout layout = new FormLayout("fill:p:g", "f:p:g, 3dlu, f:p");
        panel.setLayout((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
        builder.append((Component)this.view);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)today);
    }

    private void closeWindow() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

