/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import jgnash.engine.Account;
import jgnash.engine.EngineFactory;

public class ExpandingAccountTableNode
implements Comparable<ExpandingAccountTableNode> {
    private String accountUuid;
    private Account account;
    private boolean expanded = true;

    ExpandingAccountTableNode(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account may not be null");
        }
        this.account = account;
        this.accountUuid = account.getUuid();
    }

    public Account getAccount() {
        if (this.account == null) {
            this.account = EngineFactory.getEngine("default").getAccountByUuid(this.getAccountUuid());
        }
        return this.account;
    }

    public String getAccountUuid() {
        return this.accountUuid;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getDepth() {
        return this.getAccount().getDepth();
    }

    @Override
    public int compareTo(ExpandingAccountTableNode node) {
        return this.getAccount().compareTo(node.getAccount());
    }

    public int hashCode() {
        return this.getAccount().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ExpandingAccountTableNode) {
            return this.getAccount().equals(((ExpandingAccountTableNode)object).getAccount());
        }
        return false;
    }
}

