/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumMap;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.StoredObject;
import jgnash.message.ChannelEvent;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;

public class Message
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2351895771349706585L;
    private ChannelEvent event;
    private MessageChannel channel;
    private String source;
    private transient EnumMap<MessageProperty, StoredObject> properties = new EnumMap(MessageProperty.class);
    private transient boolean remote;

    @Deprecated
    public Message() {
    }

    public Message(MessageChannel channel, ChannelEvent event, Engine source) {
        this(channel, event, source.getUuid());
    }

    private Message(MessageChannel channel, ChannelEvent event, String source) {
        assert (source != null && event != null && channel != null);
        this.source = source;
        this.event = event;
        this.channel = channel;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ChannelEvent getEvent() {
        return this.event;
    }

    public void setObject(MessageProperty key, StoredObject value) {
        this.properties.put(key, value);
    }

    public Object getObject(MessageProperty key) {
        return this.properties.get((Object)key);
    }

    public String getSource() {
        return this.source;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.properties.size());
        Object[] values = this.properties.values().toArray();
        MessageProperty[] keys = this.properties.keySet().toArray(new MessageProperty[this.properties.size()]);
        for (int i = 0; i < this.properties.size(); ++i) {
            s.writeObject((Object)keys[i]);
            if (!(values[i] instanceof StoredObject)) {
                throw new IOException("Could not store object: " + keys[i].toString());
            }
            s.writeUTF(((StoredObject)values[i]).getUuid());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.properties = new EnumMap(MessageProperty.class);
        int size = s.readInt();
        Engine engine = EngineFactory.getEngine("default");
        for (int i = 0; i < size; ++i) {
            MessageProperty key = (MessageProperty)((Object)s.readObject());
            StoredObject value = engine.getStoredObjectByUuid(s.readUTF());
            this.properties.put(key, value);
        }
    }

    public Message clone() {
        Message m = null;
        try {
            m = (Message)super.clone();
            m.properties = this.properties.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return m;
    }
}

