/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.file;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.text.StyledEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jgnash.engine.Account;
import jgnash.engine.AccountTreeXMLFactory;
import jgnash.engine.RootAccount;
import jgnash.ui.components.CheckListCellRenderer;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.ui.util.ToggleSelectionModel;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.ClassPathUtils;
import jgnash.util.Resource;

public class NewFileFour
extends JPanel
implements WizardPage {
    private final Resource rb = Resource.get();
    private static final String ROOTPATH = "/jgnash/resource/account";
    private JList accountList;
    private JTree accountTree;
    private JEditorPane helpPane;

    public NewFileFour() {
        this.layoutMainPanel();
        DefaultListModel<RootAccount> model = new DefaultListModel<RootAccount>();
        for (RootAccount account : NewFileFour.getLocalizedAccountSet()) {
            model.addElement(account);
        }
        this.accountList.setModel(model);
        this.accountList.setSelectionModel(new ToggleSelectionModel());
        this.accountList.setCellRenderer(new CheckListCellRenderer(this.accountList.getCellRenderer()));
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("min(85dlu;d), 8dlu, min(65dlu;d):g(1.0)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.ChooseAccounts"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:50dlu:g"));
        builder.append((Component)new JScrollPane(this.accountList), (Component)new JScrollPane(this.accountTree));
    }

    private void initComponents() {
        this.accountList = new JList();
        this.accountList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewFileFour.this.accountListMouseClicked(evt);
            }
        });
        this.accountTree = new JTree();
        this.accountTree.setModel(null);
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("NewFileFour.txt"));
    }

    private void accountListMouseClicked(MouseEvent evt) {
        int[] indices;
        int index = this.accountList.locationToIndex(evt.getPoint());
        if (index > -1 && Arrays.binarySearch(indices = this.accountList.getSelectedIndices(), index) > -1) {
            RootAccount root = (RootAccount)this.accountList.getModel().getElementAt(index);
            this.accountTree.setModel(new AccountModel(root));
            this.expandTree();
            return;
        }
        Object o = this.accountList.getSelectedValue();
        if (o != null) {
            this.accountTree.setModel(new AccountModel((RootAccount)o));
            this.expandTree();
        } else {
            this.accountTree.setModel(null);
        }
    }

    private void expandTree() {
        for (int i = 0; i < this.accountTree.getRowCount(); ++i) {
            this.accountTree.expandRow(i);
        }
    }

    @Override
    public String toString() {
        return "4. " + this.rb.getString("Title.ChooseAccounts");
    }

    @Override
    public boolean isPageValid() {
        return true;
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        ArrayList<RootAccount> accounts = new ArrayList<RootAccount>();
        for (Object o : this.accountList.getSelectedValues()) {
            accounts.add((RootAccount)o);
        }
        map.put(NewFileDialog.Settings.ACCOUNTSET, accounts);
    }

    private static Collection<RootAccount> getLocalizedAccountSet() {
        ArrayList<RootAccount> files = new ArrayList<RootAccount>();
        for (String string : NewFileFour.getAccountSetList()) {
            InputStream stream = Object.class.getResourceAsStream(string);
            if (stream == null) continue;
            RootAccount account = AccountTreeXMLFactory.loadAccountTree(stream);
            files.add(account);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAccountSetList() {
        String path = ClassPathUtils.getLocalizedPath(ROOTPATH);
        ArrayList<String> set = new ArrayList<String>();
        if (path != null) {
            BufferedReader r = null;
            try {
                InputStream stream = Object.class.getResourceAsStream(path + "/set.txt");
                if (stream != null) {
                    r = new BufferedReader(new InputStreamReader(stream));
                    String line = r.readLine();
                    while (line != null) {
                        set.add(path + "/" + line);
                        line = r.readLine();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(NewFileFour.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(NewFileFour.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return set;
    }

    private static class AccountModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 754534776718585809L;

        public AccountModel(RootAccount root) {
            super(null);
            this.loadAccountTree(root);
        }

        void loadAccountTree(Account account) {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(account);
            this.setRoot(rootNode);
            this.loadChildren(rootNode);
            this.nodeStructureChanged(rootNode);
        }

        private void loadChildren(DefaultMutableTreeNode parentNode) {
            Account parent = (Account)parentNode.getUserObject();
            for (Account child : parent.getChildren()) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                this.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (child.getChildCount() <= 0) continue;
                this.loadChildren(childNode);
            }
        }
    }
}

