/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.Comparators;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageProperty;
import jgnash.ui.register.table.RegisterTableModel;
import jgnash.ui.register.table.SortableTableModel;

public class SortedTableModel
extends RegisterTableModel
implements SortableTableModel {
    private static final long serialVersionUID = -7009845379286807436L;
    List<Transaction> transactions = new ArrayList<Transaction>();
    private int sortColumn = 0;
    private boolean ascending = true;
    private boolean[] sortedColumnMap;
    private boolean[] sortColumns;
    private Comparator<Transaction> comparator = Comparators.getTransactionByDate();
    final Object lock = new Object();

    public SortedTableModel(Account account, String[] names) {
        super(account, names);
        this.getTransactions();
    }

    private boolean[] getSortableColumns() {
        return new boolean[]{true, true, true, true, true, false, true, true, false};
    }

    @Override
    protected void buildColumnMap() {
        super.buildColumnMap();
        if (this.sortColumns == null) {
            this.sortColumns = this.getSortableColumns();
        }
        this.sortedColumnMap = new boolean[this.getColumnCount()];
        int index = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (!this.columnVisible[i]) continue;
            this.sortedColumnMap[index] = this.sortColumns[i];
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTransactions() {
        Object object = this.lock;
        synchronized (object) {
            this.transactions = this.account.getTransactions();
            Collections.sort(this.transactions, this.comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.transactions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction getTransactionAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ascending) {
                return this.transactions.get(index);
            }
            return this.transactions.get(this.transactions.size() - index - 1);
        }
    }

    @Override
    public int indexOf(Transaction t) {
        return this.transactions.indexOf(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBalanceAt(int index) {
        if (this.balanceCache.get(index) != null) {
            return this.balanceCache.get(index);
        }
        if (index > 0 && this.balanceCache.get(index - 1) != null) {
            BigDecimal bal = this.balanceCache.get(index - 1);
            bal = bal.add(this.getTransactionAt(index).getAmount(this.account));
            this.balanceCache.set(index, bal);
            return bal;
        }
        BigDecimal bal = BigDecimal.ZERO;
        if (this.transactions != null) {
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i <= index; ++i) {
                    bal = bal.add(this.getTransactionAt(i).getAmount(this.account));
                }
            }
        }
        this.balanceCache.set(index, bal);
        return bal;
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT) == this.account) {
            switch (event.getEvent()) {
                case FILE_CLOSING: {
                    this.dispose();
                    return;
                }
                case TRANSACTION_ADD: {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SortedTableModel.this.balanceCache.ensureCapacity(SortedTableModel.this.account.getTransactionCount());
                            SortedTableModel.this.addTransaction((Transaction)event.getObject(MessageProperty.TRANSACTION));
                        }
                    });
                    return;
                }
                case TRANSACTION_REMOVE: {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SortedTableModel.this.removeTransaction((Transaction)event.getObject(MessageProperty.TRANSACTION));
                        }
                    });
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransaction(Transaction t) {
        Object object = this.lock;
        synchronized (object) {
            int index = Collections.binarySearch(this.transactions, t, this.comparator);
            if (index < 0) {
                int i = -index - 1;
                this.transactions.add(i, t);
                if (i >= 1) {
                    this.balanceCache.clear(i - 1);
                } else {
                    this.balanceCache.clear();
                }
                this.fireTableRowsInserted(i, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransaction(Transaction t) {
        Object object = this.lock;
        synchronized (object) {
            int i = this.transactions.indexOf(t);
            if (i >= 0) {
                this.transactions.remove(t);
                if (i >= 1) {
                    this.balanceCache.clear(i - 1);
                } else {
                    this.balanceCache.clear();
                }
                this.fireTableRowsDeleted(i, i);
            }
        }
    }

    @Override
    public boolean isSortable(int col) {
        return this.sortedColumnMap[col];
    }

    @Override
    public void sortColumn(int col, boolean ascending1) {
        this.ascending = ascending1;
        this.sortColumn = col;
        switch (this.getColumnMapping(col)) {
            case 0: {
                this.comparator = Comparators.getTransactionByDate();
                break;
            }
            case 1: {
                this.comparator = Comparators.getTransactionByNumber();
                break;
            }
            case 2: {
                this.comparator = Comparators.getTransactionByPayee();
                break;
            }
            case 3: {
                this.comparator = Comparators.getTransactionByMemo();
                break;
            }
            case 4: {
                this.comparator = new Comparators.TransactionByAccount(this.account);
                break;
            }
            case 6: 
            case 7: {
                this.comparator = Comparators.getTransactionByAmount();
                break;
            }
            default: {
                this.comparator = Comparators.getTransactionByDate();
            }
        }
        Collections.sort(this.transactions, this.comparator);
        this.balanceCache.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getSortedColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean getAscending() {
        return this.ascending;
    }
}

