/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.UIApplication;
import jgnash.ui.register.AbstractRegisterPanel;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class RegisterFrame
extends JFrame
implements MessageListener {
    private static EventListenerList listenerList = new EventListenerList();
    private static List<RegisterFrame> dialogList = new ArrayList<RegisterFrame>();
    private Account account = null;
    private AbstractRegisterPanel panel = null;

    private RegisterFrame(Account account) {
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.account = account;
        this.updateTitle();
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        this.panel = RegisterFactory.createRegisterPanel(account);
        this.getContentPane().add((Component)this.panel, "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
        Dimension d = UIApplication.getFrame().getSize();
        this.setSize(new Dimension((int)(d.getWidth() * 0.7), (int)(d.getHeight() * 0.7)));
        this.setLocationRelativeTo(UIApplication.getFrame());
        this.setDefaultCloseOperation(2);
        DialogUtils.addBoundsListener(this, Integer.toString(account.hashCode()));
        dialogList.add(this);
        this.panel.restoreColumnLayout();
        this.fireOpenEvent();
    }

    private RegisterFrame(Account account, Transaction t) {
        this(account);
        if (t != null) {
            this.setSelectedTransaction(t);
        }
    }

    @Override
    public void dispose() {
        dialogList.remove(this);
        this.fireCloseEvent();
        super.dispose();
    }

    public static void addRegisterListener(RegisterListener l) {
        listenerList.add(RegisterListener.class, l);
    }

    private void fireOpenEvent() {
        this.fireEvent(RegisterEvent.Action.OPEN);
    }

    private void fireCloseEvent() {
        this.fireEvent(RegisterEvent.Action.CLOSE);
    }

    private void fireEvent(RegisterEvent.Action action) {
        RegisterEvent e = null;
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegisterListener.class) continue;
            if (e == null) {
                e = new RegisterEvent(this, action);
            }
            ((RegisterListener)listeners[i + 1]).registerEvent(e);
        }
    }

    private void updateTitle() {
        this.setTitle("jGnash - " + this.account.getPathName());
    }

    @Override
    public String toString() {
        return this.account.getName();
    }

    private Account getAccount() {
        return this.account;
    }

    void setSelectedTransaction(Transaction t) {
        this.panel.setSelectedTransaction(t);
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT).equals(this.account)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case ACCOUNT_MODIFY: {
                            RegisterFrame.this.updateTitle();
                            break;
                        }
                        case ACCOUNT_REMOVE: {
                            RegisterFrame.this.dispatchEvent(new WindowEvent(RegisterFrame.this, 201));
                            break;
                        }
                    }
                }
            });
        }
    }

    @Override
    public void toFront() {
        for (Window w : Window.getOwnerlessWindows()) {
            if (w == this) continue;
            w.toBack();
        }
        super.toFront();
    }

    public static void showDialog(Account account) {
        RegisterFrame.showDialog(account, null);
    }

    protected static void showDialog(final Account account, final Transaction t) {
        for (final RegisterFrame d : dialogList) {
            if (!account.equals(d.getAccount())) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (t != null) {
                        d.setSelectedTransaction(t);
                    }
                    if (d.getExtendedState() == 1) {
                        d.setExtendedState(0);
                    }
                    d.toFront();
                }
            });
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RegisterFrame(account, t).setVisible(true);
            }
        });
    }
}

