/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import jgnash.util.Resource;

public final class PasswordDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private char[] password = null;
    private JPasswordField passwordField;
    private JPasswordField verifyField;
    private JButton okButton;
    private JButton cancelButton;
    private boolean result;
    private Type type;

    public PasswordDialog(JFrame parent, Type type) {
        super((Frame)parent, true);
        this.type = type;
        this.setTitle(this.rb.getString("Title.EnterPassword"));
        this.setDefaultCloseOperation(2);
        this.layoutPanel();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public char[] getPassword() {
        return (char[])this.password.clone();
    }

    public boolean getResult() {
        return this.result;
    }

    private void layoutPanel() {
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        EnterKeyListener l = new EnterKeyListener();
        FormLayout layout = new FormLayout("right:p, 4dlu, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        this.passwordField = new JPasswordField(25);
        this.passwordField.addKeyListener(l);
        builder.append(this.rb.getString("Label.Password"), (Component)this.passwordField);
        if (this.type.equals((Object)Type.SET)) {
            this.verifyField = new JPasswordField(25);
            this.verifyField.addKeyListener(l);
            builder.append(this.rb.getString("Label.Verify"), (Component)this.verifyField);
        }
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.type == Type.GET) {
                this.password = this.passwordField.getPassword();
                this.result = true;
                this.closeDialog();
            } else if (new String(this.passwordField.getPassword()).equals(new String(this.verifyField.getPassword())) && this.passwordField.getPassword().length > 0) {
                this.password = this.passwordField.getPassword();
                this.result = true;
                this.closeDialog();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.result = false;
            this.closeDialog();
        }
    }

    static /* synthetic */ char[] access$302(PasswordDialog x0, char[] x1) {
        x0.password = x1;
        return x1;
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (PasswordDialog.this.type == Type.GET && e.getSource() == PasswordDialog.this.passwordField) {
                    if (PasswordDialog.this.passwordField.getPassword().length > 0) {
                        PasswordDialog.access$302(PasswordDialog.this, PasswordDialog.this.passwordField.getPassword());
                        PasswordDialog.this.result = true;
                        PasswordDialog.this.closeDialog();
                    }
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }
    }

    public static enum Type {
        GET,
        SET;

    }
}

