/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JTable;
import jgnash.engine.CommodityNode;
import jgnash.engine.Transaction;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.ColoredTableCellRenderer;
import jgnash.ui.register.table.AbstractRegisterTableModel;

public abstract class ColoredCommodityTableCellRenderer
extends ColoredTableCellRenderer {
    private NumberFormat format = this.getNumberFormat();

    private ColoredCommodityTableCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    abstract NumberFormat getNumberFormat();

    public void setValue(Object value) {
        this.setText(value != null ? this.format.format(value) : "");
    }

    public static ColoredCommodityTableCellRenderer getFullRenderer(final CommodityNode node) {
        return new ColoredCommodityTableCellRenderer(){

            @Override
            NumberFormat getNumberFormat() {
                return CommodityFormat.getFullNumberFormat(node);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (((BigDecimal)value).signum() < 0) {
                        c.setForeground(Color.RED);
                    } else {
                        c.setForeground(table.getForeground());
                    }
                } else {
                    c.setForeground(table.getSelectionForeground());
                }
                return c;
            }
        };
    }

    public static ColoredCommodityTableCellRenderer getFullTransactionRenderer(final CommodityNode node) {
        return new ColoredCommodityTableCellRenderer(){

            @Override
            NumberFormat getNumberFormat() {
                return CommodityFormat.getFullNumberFormat(node);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Transaction t;
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (((BigDecimal)value).signum() < 0) {
                        c.setForeground(Color.RED);
                    } else {
                        c.setForeground(table.getForeground());
                    }
                } else {
                    c.setForeground(table.getSelectionForeground());
                }
                if (table.getModel() instanceof AbstractRegisterTableModel && (t = ((AbstractRegisterTableModel)table.getModel()).getTransactionAt(row)).getDate().after(new Date())) {
                    c.setFont(c.getFont().deriveFont(2));
                }
                return c;
            }
        };
    }

    public static ColoredCommodityTableCellRenderer getSimpleRenderer(final CommodityNode node) {
        return new ColoredCommodityTableCellRenderer(){

            @Override
            NumberFormat getNumberFormat() {
                return CommodityFormat.getShortNumberFormat(node);
            }
        };
    }

    public static ColoredCommodityTableCellRenderer getSimpleTransactionRenderer(final CommodityNode node) {
        return new ColoredCommodityTableCellRenderer(){

            @Override
            NumberFormat getNumberFormat() {
                return CommodityFormat.getShortNumberFormat(node);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Transaction t;
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (table.getModel() instanceof AbstractRegisterTableModel && (t = ((AbstractRegisterTableModel)table.getModel()).getTransactionAt(row)).getDate().after(new Date())) {
                    c.setFont(c.getFont().deriveFont(2));
                }
                return c;
            }
        };
    }
}

