/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CommodityNode;
import jgnash.engine.SecurityNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AbstractCommodityComboBox;

public class AccountSecurityComboBox
extends AbstractCommodityComboBox<SecurityNode> {
    private Account account;

    public AccountSecurityComboBox(Account acc) {
        assert (acc.getAccountType().equals((Object)AccountType.INVEST) || acc.getAccountType().equals((Object)AccountType.MUTUAL));
        this.account = acc;
        this.addAll(this.account.getSecurities());
        if (this.model.getSize() > 0) {
            this.setSelectedIndex(0);
        }
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    @Override
    public void messagePosted(final Message event) {
        Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
        if (this.account.equals(a)) {
            final SecurityNode node = (SecurityNode)event.getObject(MessageProperty.COMMODITY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case ACCOUNT_REMOVE: {
                            MessageBus.getInstance().unregisterListener(AccountSecurityComboBox.this, MessageChannel.ACCOUNT);
                            MessageBus.getInstance().unregisterListener(AccountSecurityComboBox.this, MessageChannel.COMMODITY);
                            AccountSecurityComboBox.this.model.removeAllElements();
                            AccountSecurityComboBox.this.account = null;
                            break;
                        }
                        case ACCOUNT_SECURITY_ADD: {
                            AccountSecurityComboBox.this.model.addElement(node);
                            break;
                        }
                        case CURRENCY_REMOVE: 
                        case ACCOUNT_SECURITY_REMOVE: {
                            Object snode = AccountSecurityComboBox.this.getSelectedNode();
                            AccountSecurityComboBox.this.model.removeElement(node);
                            if (snode == null || node == null || !((CommodityNode)snode).equals(node)) break;
                            AccountSecurityComboBox.this.setSelectedItem(null);
                            break;
                        }
                        case CURRENCY_MODIFY: {
                            AccountSecurityComboBox.this.updateNode(node);
                            break;
                        }
                    }
                }
            });
        }
    }
}

