/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.imports.GenericImport;
import jgnash.imports.ImportBank;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.wizards.imports.ImportDialog;
import jgnash.util.Resource;
import net.bzzt.swift.mt940.Mt940File;
import net.bzzt.swift.mt940.exporter.Mt940Exporter;
import net.bzzt.swift.mt940.parser.Mt940Parser;

public class ImportMt940Action
extends AbstractEnabledAction {
    private static final long serialVersionUID = 6035990853524843671L;

    private static void importMt940() {
        File file;
        Resource rb = Resource.get();
        if (EngineFactory.getEngine("default").getRootAccount().getChildCount() == 0) {
            StaticUIMethods.displayError(rb.getString("Message.ErrorCreateBasicAccounts"));
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(UIApplication.getFrame()) == 0 && (file = chooser.getSelectedFile()).exists()) {
            new ImportMt940(file.getAbsolutePath()).execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImportMt940Action.importMt940();
    }

    static final class ImportMt940
    extends SwingWorker<ImportBank, Void> {
        private String fileName;

        protected ImportMt940(String fileName) {
            this.fileName = fileName;
        }

        @Override
        protected ImportBank doInBackground() throws Exception {
            Mt940Parser parser = new Mt940Parser();
            Mt940File parsedFile = parser.parse(new LineNumberReader(new InputStreamReader(new FileInputStream(this.fileName))));
            return Mt940Exporter.convert(parsedFile);
        }

        @Override
        protected void done() {
            try {
                ImportDialog d = new ImportDialog();
                ImportBank bank = (ImportBank)this.get();
                d.setSetting(ImportDialog.Settings.BANK, bank);
                d.setVisible(true);
                if (d.isWizardValid()) {
                    Account account = (Account)d.getSetting(ImportDialog.Settings.ACCOUNT);
                    List transactions = (List)d.getSetting(ImportDialog.Settings.TRANSACTIONS);
                    GenericImport.importTransactions(transactions, account);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

