/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.ui.ThemeManager;
import jgnash.ui.account.ExpandingAccountTableModel;
import jgnash.ui.actions.ReconcileAccountAction;

class ExpandingAccountTablePane
extends JScrollPane {
    ExpandingAccountTableModel model = new ExpandingAccountTableModel();
    JTable accountTable;
    private int iconIndent;
    private Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
    private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
    private int iconSpacing = 0;

    public ExpandingAccountTablePane() {
        this.model = new ExpandingAccountTableModel();
        this.iconIndent = this.expandedIcon.getIconWidth();
        if (ThemeManager.isLookAndFeelJGoodies() || ThemeManager.isLookAndFeelMotif()) {
            this.iconSpacing = 5;
        }
        this.accountTable = new ExpandingTable(this.model);
        this.accountTable.setShowGrid(false);
        this.setRowHeight();
        this.accountTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int range = Math.max(UIManager.getIcon("Tree.expandedIcon").getIconWidth(), UIManager.getIcon("Tree.collapsedIcon").getIconWidth());
                Account a = ExpandingAccountTablePane.this.getSelectedAccount(point);
                if (a != null) {
                    range += ExpandingAccountTablePane.this.iconIndent * a.getDepth();
                }
                if (e.getX() < range + 5) {
                    ExpandingAccountTablePane.this.processMouseClicked(ExpandingAccountTablePane.this.getSelectedAccount(point));
                }
            }
        });
        this.accountTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    ExpandingAccountTablePane.this.processMouseClicked(ExpandingAccountTablePane.this.getSelectedAccount());
                }
            }
        });
        this.setViewportView(this.accountTable);
    }

    private void setRowHeight() {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        int height = (int)Math.floor((float)((JLabel)((Object)new JTree().getCellRenderer())).getFont().getSize() * 1.0f / 72.0f * (float)dpi) + 2;
        if (this.openIcon != null) {
            height = Math.max(height, this.openIcon.getIconHeight());
        }
        if (this.closedIcon != null) {
            height = Math.max(height, this.closedIcon.getIconHeight());
        }
        if (this.leafIcon != null) {
            height = Math.max(height, this.leafIcon.getIconHeight());
        }
        if (this.collapsedIcon != null) {
            height = Math.max(height, this.collapsedIcon.getIconHeight());
        }
        if (this.expandedIcon != null) {
            height = Math.max(height, this.expandedIcon.getIconHeight());
        }
        this.accountTable.setRowHeight(height);
    }

    public Account getSelectedAccount() {
        Account selected = null;
        int row = this.accountTable.getSelectedRow();
        if (row >= 0) {
            selected = this.model.getAccountAt(row);
        }
        return selected;
    }

    Account getSelectedAccount(Point p) {
        Account selected = null;
        int row = this.accountTable.rowAtPoint(p);
        if (row >= 0) {
            selected = this.model.getAccountAt(row);
        }
        return selected;
    }

    void setSelectedAccount(Account account) {
        int index = this.model.getAccountIndex(account);
        if (index >= 0) {
            this.accountTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private Account getAccountAt(int rowIndex) {
        return this.model.getAccountAt(rowIndex);
    }

    void reconcileAccount() {
        ReconcileAccountAction.reconcileAccount(this.getSelectedAccount());
    }

    private void processMouseClicked(final Account account) {
        if (account != null) {
            this.model.toggleExpansion(account);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExpandingAccountTablePane.this.setSelectedAccount(account);
                }
            });
        }
    }

    private static class EmptyIndentedIcon
    implements Icon {
        private int height;
        private int width;

        public EmptyIndentedIcon(Icon[] referenceIcons, int indent) {
            for (Icon icon : referenceIcons) {
                if (icon == null) continue;
                this.width += icon.getIconWidth();
            }
            this.width += indent;
            for (Icon icon : referenceIcons) {
                if (icon == null) continue;
                this.height = Math.max(this.height, icon.getIconHeight());
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class IndentedIcon
    implements Icon {
        private Icon[] icons;
        private int indent;
        private int height;
        private int width;
        private int iconSpacing;

        public IndentedIcon(Icon[] icons, int indent, int iconSpacing) {
            this.icons = icons;
            this.indent = indent;
            this.iconSpacing = iconSpacing;
            for (Icon icon : icons) {
                if (icon == null) continue;
                this.width += icon.getIconWidth();
                this.width += iconSpacing;
            }
            this.width += indent;
            this.width -= iconSpacing;
            for (Icon icon : icons) {
                if (icon == null) continue;
                this.height = Math.max(this.height, icon.getIconHeight());
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int paintX = x + this.indent;
            for (Icon icon : this.icons) {
                if (icon == null) continue;
                int paintY = y;
                if (icon.getIconHeight() < this.getIconHeight()) {
                    paintY = this.getIconHeight() / 2 - icon.getIconHeight() / 2;
                }
                icon.paintIcon(c, g, paintX, y + paintY);
                paintX += icon.getIconWidth();
                paintX += this.iconSpacing;
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private final class ExpandingTable
    extends JTable {
        private AtomicBoolean defaultSaved;
        private Color defaultForeground;
        private int defaultAlignment;

        public ExpandingTable(TableModel model) {
            super(model);
            this.defaultSaved = new AtomicBoolean();
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (c instanceof JLabel) {
                if (!this.defaultSaved.get()) {
                    this.defaultForeground = c.getForeground();
                    this.defaultAlignment = ((JLabel)c).getHorizontalAlignment();
                    this.defaultSaved.set(true);
                }
                if (ExpandingAccountTablePane.this.model.getColumnClass(column).isAssignableFrom(BigDecimal.class)) {
                    ((JLabel)c).setHorizontalAlignment(4);
                    Account account = ExpandingAccountTablePane.this.model.getAccountAt(row);
                    if (account.getTreeBalance().signum() < 0) {
                        c.setForeground(Color.RED);
                    } else {
                        c.setForeground(this.defaultForeground);
                    }
                } else if (column == 0) {
                    c.setForeground(this.defaultForeground);
                    ((JLabel)c).setHorizontalAlignment(2);
                    Account a = ExpandingAccountTablePane.this.getAccountAt(row);
                    if (a != null) {
                        int indent = ExpandingAccountTablePane.this.iconIndent * (a.getDepth() - 1);
                        if (a.isParent()) {
                            if (ExpandingAccountTablePane.this.model.isExpanded(a)) {
                                ((JLabel)c).setIcon(new IndentedIcon(new Icon[]{ExpandingAccountTablePane.this.expandedIcon, ExpandingAccountTablePane.this.openIcon}, indent, ExpandingAccountTablePane.this.iconSpacing));
                            } else {
                                ((JLabel)c).setIcon(new IndentedIcon(new Icon[]{ExpandingAccountTablePane.this.collapsedIcon, ExpandingAccountTablePane.this.closedIcon}, indent, ExpandingAccountTablePane.this.iconSpacing));
                            }
                        } else {
                            ((JLabel)c).setIcon(new IndentedIcon(new Icon[]{new EmptyIndentedIcon(new Icon[]{ExpandingAccountTablePane.this.expandedIcon}, 0), ExpandingAccountTablePane.this.leafIcon}, indent, ExpandingAccountTablePane.this.iconSpacing));
                        }
                    }
                } else {
                    c.setForeground(this.defaultForeground);
                    ((JLabel)c).setHorizontalAlignment(this.defaultAlignment);
                    ((JLabel)c).setIcon(null);
                }
            }
            return c;
        }
    }
}

