/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import jgnash.engine.Account;
import jgnash.engine.AmortizeObject;
import jgnash.ui.account.AccountListDialog;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class AmortizeDialog
extends JDialog
implements ActionListener {
    private Resource rb = Resource.get();
    private JButton cancelButton;
    private JButton okButton;
    private JFloatField interestField;
    private JFloatField loanAmountField;
    private JIntegerField loanTermField;
    private JIntegerField payPeriodsField;
    private JIntegerField intPeriodsField;
    private JFloatField feesField;
    private JButton interestAccButton;
    private JButton bankAccButton;
    private JButton feesAccButton;
    private JTextFieldEx memoField;
    private JTextFieldEx payeeField;
    private DatePanel dateField;
    private JFloatField daysField;
    private JCheckBox useDaysButton;
    private Account bankAccount;
    private Account interestAccount;
    private Account feesAccount;
    private boolean result = false;
    private AmortizeObject ao;

    public AmortizeDialog(AmortizeObject o) {
        super((Frame)null, true);
        this.setTitle(this.rb.getString("Title.AmorSetup"));
        this.setModal(true);
        this.layoutMainPanel();
        this.setDefaultCloseOperation(2);
        this.bankAccButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.feesAccButton.addActionListener(this);
        this.interestAccButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.useDaysButton.addActionListener(this);
        this.ao = o != null ? o : AmortizeDialog.generateDefault();
        this.fillForm();
        this.pack();
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        this.dateField = new DatePanel();
        this.interestField = new JFloatField(0, 3, 2);
        this.loanAmountField = new JFloatField();
        this.loanTermField = new JIntegerField();
        this.payPeriodsField = new JIntegerField();
        this.intPeriodsField = new JIntegerField();
        this.feesField = new JFloatField();
        this.interestAccButton = new JButton(this.rb.getString("Word.None"));
        this.bankAccButton = new JButton(this.rb.getString("Word.None"));
        this.feesAccButton = new JButton(this.rb.getString("Word.None"));
        this.payeeField = new JTextFieldEx();
        this.memoField = new JTextFieldEx();
        this.useDaysButton = new JCheckBox(this.rb.getString("Button.UseDailyRate"));
        this.daysField = new JFloatField();
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:max(40dlu;pref), $lcgap, max(75dlu;pref):grow(1.0)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.appendSeparator(this.rb.getString("Title.AmortizationSetup"));
        builder.append(this.rb.getString("Label.AnIntRate"), (Component)this.interestField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.OrigLoanAmt"), (Component)this.loanAmountField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.LoanTerm"), (Component)this.loanTermField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.PayPerTerm"), (Component)this.payPeriodsField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.CompPerTerm"), (Component)this.intPeriodsField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.FirstPayDate"), (Component)this.dateField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.EscrowPmi"), (Component)this.feesField);
        builder.nextLine();
        builder.setLeadingColumnOffset(2);
        builder.append((Component)this.useDaysButton);
        builder.setLeadingColumnOffset(0);
        builder.nextLine();
        builder.append(this.rb.getString("Label.CompDaysPerYear"), (Component)this.daysField);
        builder.appendSeparator(this.rb.getString("Title.TransactionSetup"));
        builder.append(this.rb.getString("Label.InterestAccount"), (Component)this.interestAccButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.BankAccount"), (Component)this.bankAccButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.FeesAccount"), (Component)this.feesAccButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Payee"), (Component)this.payeeField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Memo"), (Component)this.memoField);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add((Component)builder.getPanel(), "Center");
    }

    public boolean getResult() {
        return this.result;
    }

    public AmortizeObject getAmortizeObject() {
        AmortizeObject o = new AmortizeObject();
        o.setDate(this.dateField.getDate());
        o.setFees(this.feesField.getDecimal());
        o.setInterestPeriods(this.intPeriodsField.intValue());
        o.setPaymentPeriods(this.payPeriodsField.intValue());
        o.setPrincipal(this.loanAmountField.getDecimal());
        o.setRate(this.interestField.getDecimal());
        o.setLength(this.loanTermField.intValue());
        o.setPayee(this.payeeField.getText());
        o.setMemo(this.memoField.getText());
        o.setUseDailyRate(this.useDaysButton.isSelected());
        o.setDaysPerYear(this.daysField.getDecimal());
        if (this.bankAccount != null) {
            o.setBankAccount(this.bankAccount);
        }
        if (this.interestAccount != null) {
            o.setInterestAccount(this.interestAccount);
        }
        if (this.feesAccount != null) {
            o.setFeesAccount(this.feesAccount);
        }
        return o;
    }

    private static AmortizeObject generateDefault() {
        AmortizeObject o = new AmortizeObject();
        o.setLength(360);
        o.setPaymentPeriods(12);
        o.setRate(new BigDecimal("5.75"));
        o.setPrincipal(new BigDecimal("80000.00"));
        o.setUseDailyRate(false);
        o.setDaysPerYear(new BigDecimal("365"));
        if (Locale.getDefault().getCountry().equals("CA")) {
            o.setInterestPeriods(4);
        } else {
            o.setInterestPeriods(12);
        }
        return o;
    }

    private void fillForm() {
        this.interestField.setDecimal(this.ao.getRate());
        this.loanAmountField.setDecimal(this.ao.getPrincipal());
        this.loanTermField.setIntValue(this.ao.getLength());
        this.payPeriodsField.setIntValue(this.ao.getPaymentPeriods());
        this.intPeriodsField.setIntValue(this.ao.getInterestPeriods());
        this.feesField.setDecimal(this.ao.getFees());
        this.memoField.setText(this.ao.getMemo());
        this.payeeField.setText(this.ao.getPayee());
        this.dateField.setDate(this.ao.getDate());
        this.daysField.setDecimal(this.ao.getDaysPerYear());
        this.useDaysButton.setSelected(this.ao.getUseDailyRate());
        this.daysField.setEnabled(this.ao.getUseDailyRate());
        Account a = this.ao.getBankAccount();
        if (a != null) {
            this.bankAccount = a;
            this.bankAccButton.setText(a.getName());
        }
        if ((a = this.ao.getInterestAccount()) != null) {
            this.interestAccount = a;
            this.interestAccButton.setText(a.getName());
        }
        if ((a = this.ao.getFeesAccount()) != null) {
            this.feesAccount = a;
            this.feesAccButton.setText(a.getName());
        }
    }

    private Account showAccountListDialog(Account a) {
        AccountListDialog dlg = new AccountListDialog(a, true);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        if (dlg.getReturnStatus()) {
            return dlg.getAccount();
        }
        return null;
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.okButton) {
            this.result = true;
            this.closeDialog();
        } else if (e.getSource() == this.bankAccButton) {
            Account a = this.showAccountListDialog(this.bankAccount);
            if (a != null) {
                this.bankAccount = a;
                this.bankAccButton.setText(a.getName());
            } else {
                this.bankAccButton.setText(this.rb.getString("Word.None"));
            }
        } else if (e.getSource() == this.interestAccButton) {
            Account a = this.showAccountListDialog(this.interestAccount);
            if (a != null) {
                this.interestAccount = a;
                this.interestAccButton.setText(a.getName());
            } else {
                this.interestAccButton.setText(this.rb.getString("Word.None"));
            }
        } else if (e.getSource() == this.feesAccButton) {
            Account a = this.showAccountListDialog(this.feesAccount);
            if (a != null) {
                this.feesAccount = a;
                this.feesAccButton.setText(a.getName());
            } else {
                this.feesAccButton.setText(this.rb.getString("Word.None"));
            }
        } else if (e.getSource() == this.useDaysButton) {
            this.daysField.setEnabled(this.useDaysButton.isSelected());
        }
    }
}

