/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.qif;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jgnash.imports.qif.NoAccountException;
import jgnash.imports.qif.QifAccount;
import jgnash.imports.qif.QifCategory;
import jgnash.imports.qif.QifReader;
import jgnash.imports.qif.QifSplitTransaction;
import jgnash.imports.qif.QifTransaction;
import jgnash.imports.qif.QifUtils;

public class QifParser {
    private String dateFormat = "mm/dd/yyyy";
    private boolean debug = false;
    public ArrayList<QifCategory> categories = new ArrayList();
    private ArrayList<QifClassItem> classes = new ArrayList();
    public ArrayList<QifAccount> accountList = new ArrayList();
    private ArrayList<QifSecurity> securities = new ArrayList();
    private Logger logger = Logger.getLogger("qifimport");

    public QifParser(String dateFormat) {
        this.setDateFormat(dateFormat);
    }

    private boolean startsWith(String source, String prefix) {
        return prefix.length() <= source.length() && source.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    void setDateFormat(String dateFormat) {
        if (dateFormat != null && (dateFormat.equals("mm/dd/yyyy") || dateFormat.equals("dd/mm/yyyy"))) {
            this.dateFormat = dateFormat;
        }
    }

    void parseFullFile(File file) throws NoAccountException {
        this.parseFullFile(file.getAbsolutePath());
    }

    void parsePartialFile(File file) {
        this.parsePartialFile(file.getAbsolutePath());
    }

    private void parseFullFile(String fileName) throws NoAccountException {
        try {
            QifReader in = new QifReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                if (this.startsWith(line, "!Type:Class")) {
                    this.parseClassList(in);
                } else if (this.startsWith(line, "!Type:Cat")) {
                    this.parseCategoryList(in);
                } else if (this.startsWith(line, "!Account")) {
                    this.parseAccount(in);
                } else if (this.startsWith(line, "!Type:Memorized")) {
                    this.parseMemorizedTransactions(in);
                } else if (this.startsWith(line, "!Type:Security")) {
                    this.parseSecurity(in);
                } else if (this.startsWith(line, "!Type:Prices")) {
                    this.parsePrice(in);
                } else {
                    if (this.startsWith(line, "!Type:Bank")) {
                        in.close();
                        throw new NoAccountException();
                    }
                    if (this.startsWith(line, "!Type:CCard")) {
                        in.close();
                        throw new NoAccountException();
                    }
                    if (this.startsWith(line, "!Type:Oth")) {
                        in.close();
                        throw new NoAccountException();
                    }
                    if (this.startsWith(line, "!Type:Cash")) {
                        in.close();
                        throw new NoAccountException();
                    }
                    if (!this.startsWith(line, "!Option:AutoSwitch") && !this.startsWith(line, "!Clear:AutoSwitch")) {
                        System.out.println("Error: " + line);
                    }
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find file: " + fileName);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private boolean parsePartialFile(String fileName) {
        QifReader in = null;
        try {
            in = new QifReader(new FileReader(fileName));
            String peek = in.peekLine();
            if (this.startsWith(peek, "!Type:")) {
                QifAccount acc = new QifAccount();
                if (this.parseAccountTransactions(in, acc)) {
                    this.accountList.add(acc);
                    if (this.debug) {
                        System.out.println("*** Added account ***");
                    }
                    in.close();
                    return true;
                }
                System.err.println("parseAccountTransactions: error");
            }
            in.close();
        }
        catch (FileNotFoundException fne) {
            System.err.println("Could not find file: " + fileName);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ignored) {}
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean parseAccount(QifReader in) {
        this.logger.entering(this.getClass().getName(), "parseAccount", in);
        QifAccount acc = new QifAccount();
        boolean result = false;
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("N")) {
                    acc.name = line.substring(1);
                } else if (line.startsWith("T")) {
                    acc.type = line.substring(1);
                } else if (line.startsWith("D")) {
                    acc.description = line.substring(1);
                } else if (line.startsWith("L")) {
                    acc.creditLimit = line.substring(1);
                } else if (line.startsWith("/")) {
                    acc.statementBalanceDate = line.substring(1);
                } else if (line.startsWith("$")) {
                    acc.statementBalance = line.substring(1);
                } else if (!line.startsWith("X")) {
                    if (line.startsWith("^")) {
                        String peek = in.peekLine();
                        if (peek == null) {
                            this.accountList.add(acc);
                            result = true;
                            break;
                        }
                        if (this.startsWith(peek, "!Account")) {
                            this.accountList.add(acc);
                            acc = new QifAccount();
                            in.readLine();
                        } else {
                            QifAccount dup;
                            if (this.startsWith(peek, "!Type:Memor")) {
                                this.accountList.add(acc);
                                result = true;
                                break;
                            }
                            if (this.startsWith(peek, "!Type:Invst")) {
                                this.logger.fine("Found investment transactions");
                                dup = this.searchForDuplicate(acc);
                                if (dup != null) {
                                    acc = dup;
                                }
                                if (this.parseInvestmentAccountTransactions(in, acc)) {
                                    if (dup == null) {
                                        this.accountList.add(acc);
                                    }
                                    this.logger.finest("Added Qif Account");
                                    result = true;
                                    break;
                                }
                                acc = new QifAccount();
                            } else {
                                if (this.startsWith(peek, "!Type:Prices")) {
                                    this.logger.fine("Found commodity price; jump out");
                                    result = true;
                                    break;
                                }
                                if (this.startsWith(peek, "!Type:")) {
                                    this.logger.fine("Found bank transactions");
                                    dup = this.searchForDuplicate(acc);
                                    if (dup != null) {
                                        acc = dup;
                                    }
                                    if (this.parseAccountTransactions(in, acc)) {
                                        if (dup == null) {
                                            this.accountList.add(acc);
                                        }
                                        this.logger.finest("Added Qif Account");
                                        result = true;
                                        break;
                                    }
                                    acc = new QifAccount();
                                } else {
                                    if (this.startsWith(peek, "!Clear:Auto")) {
                                        in.readLine();
                                        this.accountList.add(acc);
                                        result = true;
                                        break;
                                    }
                                    if (this.startsWith(peek, "!")) {
                                        this.accountList.add(acc);
                                        result = true;
                                        break;
                                    }
                                    this.accountList.add(acc);
                                    acc = new QifAccount();
                                }
                            }
                        }
                    } else {
                        result = false;
                        break;
                    }
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            result = false;
        }
        this.logger.exiting(this.getClass().getName(), "parseAccount", result);
        return result;
    }

    QifAccount searchForDuplicate(QifAccount acc) {
        String name = acc.name;
        String type = acc.type;
        String description = acc.description;
        assert (description != null);
        if (name == null || type == null) {
            this.logger.severe("Invalid account: \n" + acc.toString());
            return null;
        }
        if (type.equals("Invst") || type.equals("Port")) {
            for (QifAccount a : this.accountList) {
                if (!a.name.equals(name) || !a.description.equals(description)) continue;
                this.logger.fine("Matched a duplicate account");
                return a;
            }
        } else {
            for (QifAccount a : this.accountList) {
                if (!a.name.equals(name) || !a.type.equals(type) || !a.description.equals(description)) continue;
                this.logger.fine("Matched a duplicate account");
                return a;
            }
        }
        return null;
    }

    private boolean parseAccountTransactions(QifReader in, QifAccount acc) {
        QifTransaction tran = new QifTransaction();
        try {
            String line = in.readLine();
            while (line != null) {
                if (this.startsWith(line, "!Type:")) {
                    if (this.startsWith(line, "!Type:Invst") || this.startsWith(line, "!Type:Invst")) {
                        tran.type = line.substring(1);
                    } else {
                        if (this.startsWith(line, "!Type:Memor")) {
                            in.reset();
                            return true;
                        }
                        tran.type = line.substring(1);
                    }
                } else if (line.startsWith("D")) {
                    tran.oDate = line.substring(1);
                    tran.date = QifUtils.parseDate(tran.oDate, this.dateFormat);
                } else if (line.startsWith("U")) {
                    tran.U = line.substring(1);
                } else if (line.startsWith("T")) {
                    tran.amount = QifUtils.parseMoney(line.substring(1));
                } else if (line.startsWith("C")) {
                    tran.status = line.substring(1);
                } else if (line.startsWith("P")) {
                    tran.payee = line.substring(1);
                } else if (line.startsWith("L")) {
                    tran.category = line.substring(1);
                } else if (line.startsWith("N")) {
                    tran.number = line.substring(1);
                } else if (line.startsWith("M")) {
                    tran.memo = line.substring(1);
                } else if (line.startsWith("A")) {
                    tran.addAddressLine(line.substring(1));
                } else if (line.startsWith("I")) {
                    tran.price = line.substring(1);
                } else if (line.startsWith("^")) {
                    acc.addTransaction(tran);
                    if (this.debug) {
                        System.out.println("*** Added a Transaction ***");
                    }
                    tran = new QifTransaction();
                } else {
                    if (this.startsWith(line, "!Account")) {
                        in.reset();
                        return true;
                    }
                    if (this.startsWith(line, "!Type:Prices")) {
                        in.reset();
                        return true;
                    }
                    if (line.charAt(0) == 'S' || line.charAt(0) == 'E' || line.charAt(0) == '$' || line.charAt(0) == '%') {
                        in.reset();
                        QifSplitTransaction split = this.parseSplitTransaction(in);
                        if (split != null) {
                            tran.addSplit(split);
                            if (this.debug) {
                                System.out.println("*** Added a Split Transaction ***");
                            }
                        }
                    } else if (line.charAt(0) == '$') {
                        tran.amountTrans = line.substring(1);
                    } else {
                        this.logger.severe("Unknown field: " + line);
                    }
                }
                in.mark();
                line = in.readLine();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean parseInvestmentAccountTransactions(QifReader in, QifAccount acc) {
        boolean result = true;
        this.logger.entering(this.getClass().getName(), "parseInvestmentAccountTransactions", acc);
        QifTransaction tran = new QifTransaction();
        try {
            String line = in.readLine();
            while (line != null) {
                if (this.startsWith(line, "!Type:Invst")) {
                    tran.type = line.substring(1);
                } else {
                    if (this.startsWith(line, "!Type:Memor")) {
                        in.reset();
                        result = true;
                        break;
                    }
                    if (this.startsWith(line, "!Type:Prices")) {
                        this.logger.fine("Found commodity prices; jumping out");
                        in.reset();
                        result = true;
                        break;
                    }
                    if (line.startsWith("D")) {
                        tran.oDate = line.substring(1);
                        tran.date = QifUtils.parseDate(tran.oDate, this.dateFormat);
                    } else if (line.startsWith("U")) {
                        tran.U = line.substring(1);
                    } else if (line.startsWith("T")) {
                        tran.amount = QifUtils.parseMoney(line.substring(1));
                    } else if (line.startsWith("C")) {
                        tran.status = line.substring(1);
                    } else if (line.startsWith("P")) {
                        tran.payee = line.substring(1);
                    } else if (line.startsWith("L")) {
                        tran.category = line.substring(1);
                    } else if (line.startsWith("N")) {
                        tran.number = line.substring(1);
                    } else if (line.startsWith("M")) {
                        tran.memo = line.substring(1);
                    } else if (line.startsWith("A")) {
                        tran.addAddressLine(line.substring(1));
                    } else if (line.startsWith("Y")) {
                        tran.security = line.substring(1);
                    } else if (line.startsWith("I")) {
                        tran.price = line.substring(1);
                    } else if (line.startsWith("Q")) {
                        tran.quantity = line.substring(1);
                    } else if (line.charAt(0) == '$') {
                        tran.amountTrans = line.substring(1);
                    } else if (line.startsWith("^")) {
                        acc.addTransaction(tran);
                        this.logger.finest("*** Added an investment transaction ***");
                        tran = new QifTransaction();
                    } else {
                        if (this.startsWith(line, "!Account")) {
                            in.reset();
                            result = true;
                            break;
                        }
                        if (line.charAt(0) == 'S' || line.charAt(0) == 'E' || line.charAt(0) == '$' || line.charAt(0) == '%') {
                            in.reset();
                            QifSplitTransaction split = this.parseSplitTransaction(in);
                            if (split != null) {
                                tran.addSplit(split);
                                this.logger.fine("*** Added a Split Transaction ***");
                            }
                        } else {
                            this.logger.severe("Unknown field: " + line);
                        }
                    }
                }
                in.mark();
                line = in.readLine();
            }
        }
        catch (IOException e) {
            result = false;
        }
        this.logger.exiting(this.getClass().getName(), "parseInvestmentAccountTransactions", result);
        return result;
    }

    private QifSplitTransaction parseSplitTransaction(QifReader in) {
        boolean category = false;
        boolean memo = false;
        boolean amount = false;
        boolean percentage = false;
        QifSplitTransaction split = new QifSplitTransaction();
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("S")) {
                    if (category) {
                        in.reset();
                        return split;
                    }
                    category = true;
                    split.category = line.substring(1);
                } else if (line.startsWith("E")) {
                    if (memo) {
                        in.reset();
                        return split;
                    }
                    memo = true;
                    split.memo = line.substring(1);
                } else if (line.startsWith("$")) {
                    if (amount) {
                        in.reset();
                        return split;
                    }
                    amount = true;
                    split.amount = QifUtils.parseMoney(line.substring(1));
                } else if (line.startsWith("%")) {
                    if (percentage) {
                        in.reset();
                        return split;
                    }
                    percentage = true;
                    split.percentage = line.substring(1);
                } else {
                    if (line.startsWith("^")) {
                        in.reset();
                        return split;
                    }
                    in.reset();
                    return null;
                }
                in.mark();
                line = in.readLine();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void parseMemorizedTransactions(QifReader in) {
        if (this.debug) {
            System.out.println("*** Start: parseMemorizedTransactions ***");
        }
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("K")) {
                    line = in.readLine();
                    if (line.charAt(0) == '^') {
                        String peek = in.peekLine();
                        if (peek == null) {
                            return;
                        }
                        if (!peek.startsWith("K")) {
                            break;
                        }
                    }
                } else {
                    in.reset();
                    return;
                }
                in.mark();
                line = in.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean parseCategoryList(QifReader in) {
        QifCategory cat = new QifCategory();
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("N")) {
                    cat.name = line.substring(1);
                } else if (line.startsWith("D")) {
                    cat.description = line.substring(1);
                } else if (line.startsWith("T")) {
                    cat.taxRelated = true;
                } else if (line.startsWith("I")) {
                    cat.type = "I";
                } else if (line.startsWith("E")) {
                    cat.type = "E";
                } else if (line.startsWith("B")) {
                    cat.budgetAmount = line.substring(1);
                } else if (line.startsWith("R")) {
                    cat.taxSchedule = line.substring(1);
                } else if (line.startsWith("^")) {
                    this.categories.add(cat);
                    cat = new QifCategory();
                    in.mark();
                } else {
                    if (line.startsWith("!")) {
                        in.reset();
                        return true;
                    }
                    System.out.println("Error: " + line);
                    return false;
                }
                line = in.readLine();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean parseClassList(QifReader in) {
        QifClassItem clas = new QifClassItem();
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("N")) {
                    clas.name = line.substring(1);
                } else if (line.startsWith("D")) {
                    clas.description = line.substring(1);
                } else if (line.startsWith("^")) {
                    this.classes.add(clas);
                    clas = new QifClassItem();
                    in.mark();
                } else {
                    if (line.startsWith("!")) {
                        in.reset();
                        return true;
                    }
                    System.out.println("Error: " + line);
                    return false;
                }
                line = in.readLine();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean parseSecurity(QifReader in) {
        QifSecurity sec = new QifSecurity();
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("N")) {
                    sec.name = line.substring(1);
                } else if (line.startsWith("D")) {
                    sec.description = line.substring(1);
                } else if (line.startsWith("T")) {
                    sec.type = line.substring(1);
                } else if (line.startsWith("S")) {
                    sec.symbol = line.substring(1);
                } else if (line.startsWith("^")) {
                    this.securities.add(sec);
                    sec = new QifSecurity();
                    in.mark();
                } else {
                    if (line.startsWith("!")) {
                        in.reset();
                        return true;
                    }
                    System.out.println("Error: " + line);
                    return false;
                }
                line = in.readLine();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean parsePrice(QifReader in) {
        this.logger.entering(this.getClass().getName(), "parsePrice");
        boolean result = true;
        try {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith("^")) {
                    result = true;
                    break;
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            result = false;
        }
        this.logger.exiting(this.getClass().getName(), "parsePrice", result);
        return result;
    }

    public void dumpStats() {
        System.out.println("Num Classes :" + this.classes.size());
        System.out.println("Num Categories :" + this.categories.size());
        System.out.println("Num Securities :" + this.securities.size());
        System.out.println("Num Accounts :" + this.accountList.size());
        int count = this.accountList.size();
        for (int i = 0; i < count; ++i) {
            QifAccount acc = this.accountList.get(i);
            System.out.println("Account " + (i + 1) + " " + acc.name);
            int size = acc.items.size();
            System.out.println("    Num Transactions :" + size);
            for (int j = 0; j < size; ++j) {
                QifTransaction tran = acc.items.get(j);
                System.out.println("        Transaction " + (j + 1) + " " + tran.payee);
                System.out.println("            Num Splits :" + tran.splits.size());
                for (int k = 0; k < tran.splits.size(); ++k) {
                    System.out.println("                Split " + (k + 1) + " " + tran.splits.get((int)k).memo);
                }
            }
        }
    }

    static class QifClassItem {
        String name;
        String description;

        QifClassItem() {
        }
    }

    static class QifSecurity {
        String name;
        String description;
        String symbol;
        String type;

        QifSecurity() {
        }
    }
}

